package freenet.node.http;

import freenet.node.*;
//import freenet.node.Node;
import freenet.node.http.infolets.*;
import freenet.client.http.*;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.*;
import java.io.*;
import freenet.support.servlet.*;
import freenet.interfaces.servlet.*;
import freenet.Core;
import freenet.support.Logger;

/**
 * A servlet which aggregates "Infolets", pieces of code which represent
 * some aspect of node status in HTML.  It creates a nice menu from which
 * a user may conveniently find the infolet they are looking for.
 *
 * @author     ian
 * @created    August 27, 2002
 */
public class NodeInfoServlet extends HttpServlet {

  private static Node node;
  private static Vector groups = new Vector();
  private static Hashtable lookupTable = new Hashtable();
  private static Infolet defaultInfolet = null;
  static Object staticSync = new Object();
  static boolean staticInitted = false;
  private HtmlTemplate pageTemplate, titleBoxTemplate;
  private static HtmlTemplate basePageTemplate, baseTitleBoxTemplate;
  private static String path;
  
  /**  Description of the Method */
  public final void init() throws ServletException {
    try {
	synchronized(staticSync) {
	    if(!staticInitted) {
		staticInitted = true;
		node = (Node) getServletContext().
		    getAttribute("freenet.node.Node");
		node.logger.log(this, "Initializing Infolets", Logger.DEBUG);
		
		path = getServletConfig().getInitParameter("servletContextPath");
		
		staticInit();
	    }
	}
	// Initialize templates
	pageTemplate = new HtmlTemplate(basePageTemplate);
	titleBoxTemplate = new HtmlTemplate(baseTitleBoxTemplate);
    } catch (IOException e) {
	node.logger.log(this, "Failed to Initialize HtmlTemplate", e, node.logger.ERROR);
    }
    
    
  }
  
  protected static void staticInit() throws IOException {
      basePageTemplate = HtmlTemplate.createTemplate("InfoServletTmpl.html");
      baseTitleBoxTemplate = HtmlTemplate.createTemplate("aqua/titleBox.tpl");
      /*
       *  Construct menu
       *  ==============
       *  Create the group, register it, and then register the
       *  Infolets which are to be part of that group in the order you
       *  want to see them in the menu.  The long group name should be
       *  the name which will appear in the menu, the short group name
       *  will be the name that will appear in the URL (so it should
       *  basically be nothing but lower-case alphanumeric characters).
       *  The same is true for the long and short names of the Infolets
       *  themselves.
       *  For example:
       *  Group testGroup = new Group("Long Group Name", "briefgroupname");
       *  registerGroup(testGroup);
       *  registerInfolet(testGroup, new TestInfolet());
       *  registerInfolet(testGroup, new TestInfolet2());
       *  ...
       *  Group testGroup2 = new Group("Second Long Group Name", "briefgroupname2");
       *  ...
       */
      Group performance = new Group("Performance", "performance");
      registerGroup(performance);
      registerInfolet(performance, new GeneralInfolet());
      Group network = new Group("Networking", "networking");
      registerGroup(network);
      if(!Main.publicNode) {
	  registerInfolet(network, new DownloadsInfolet());
	  registerInfolet(network, new OpenConnections());
	  registerInfolet(network, new DistributionServletInfolet());
      }
      registerInfolet(network, new LoadStatsInfolet());
      Group internal = new Group("Internals", "internal");
      registerGroup(internal);
      registerInfolet(internal, new NodeStatusInfolet()); // placeholder only
      registerInfolet(internal, new LoggerInfolet());
      registerInfolet(internal, new TickerContents());
      registerInfolet(internal, new FailureTableInfolet());
      registerInfolet(internal, new EnvironmentInfolet());
      if(!Main.publicNode) {
	  registerInfolet(internal, new RTInfolet());
      }
      // REDUNDANT    registerInfolet(internal, new ThreadFactoryInfolet());
      registerInfolet(internal, new ManualInfolet());
      defaultInfolet = new DefaultInfolet(path);
      defaultInfolet.init(node);
  }
  
  /**
   *  Render a Html page
   *
   * @param  req                   Description of the Parameter
   * @param  resp                  Description of the Parameter
   * @exception  ServletException  Description of the Exception
   * @exception  IOException       Description of the Exception
   */
  // We synchronize this method because use of the HtmlTemplate renders this code
  // thread-unsafe
  public synchronized void doGet(HttpServletRequest req, HttpServletResponse resp)
       throws ServletException, IOException {

      String path = req.getPathInfo();
      node.logger.log(this, "getPathInfo returned "+path,
		      node.logger.DEBUG);
      
      int x = (path == null) ? -1 : path.indexOf('/');
      int y = (path == null) ? -1 : path.lastIndexOf('/');
      String subset = null;
      if(x != y) {
	  subset = path.substring(y+1);
	  path = path.substring(0, y);
	  node.logger.log(this, "Broken: subset="+subset+", path="+path,
			  node.logger.DEBUG);
      }
      
      // Obtain Infolet
      Infolet i = null;
      if (path != null) {
          try {
              i = (Infolet) lookupTable.get(path);
          } catch (ClassCastException e) {}
      }
      if (i == null) {
          i = defaultInfolet;
      }
      
       
	 SimpleAdvanced_ModeUtils.handleRequestedParams(req,resp); //Parse a possible requested modechange & co
      
      node.logger.log(this, "i is "+i, node.logger.DEBUG);
      if(subset != null && i instanceof MultipleFileInfolet &&
	 ((MultipleFileInfolet)i).write(subset, req, resp)) {
      } else {
	  PrintWriter pw = resp.getWriter();
	  resp.setContentType("text/html");
	  
	  pageTemplate.set("TITLE", i.longName());
      pageTemplate.set("TOPRIGHTLINK", SimpleAdvanced_ModeUtils.renderModeSwitchLink(req.getRequestURI(),req));
	  
	  
	  StringWriter swMenu = new StringWriter(100);
	  PrintWriter pwMenu = new PrintWriter(swMenu);
	  // Display menu
	  String servletPath = req.getServletPath();
	  if (!servletPath.endsWith("/")) {
	      servletPath = servletPath + "/";
	  }
	  pwMenu.println("<a href=\"" + servletPath + "\">Web Interface</a>");
	  if(!Main.publicNode)
	      pwMenu.println("<br /><a href=\"/servlet/bookmarkmanager\">"+
			     "Bookmark Manager</a>");
	  pwMenu.println("<table><tr><td nowrap>");
	  for (Enumeration e = groups.elements(); e.hasMoreElements(); ) {
	      Group g = (Group) e.nextElement();
	      g.toHtml(pwMenu, req);
	  }
	  pwMenu.println("</td></tr></table>");
	  pwMenu.flush();
	  titleBoxTemplate.set("TITLE", "Node Information");
	  titleBoxTemplate.set("CONTENT", swMenu.toString());
	  pageTemplate.set("MENU", titleBoxTemplate);
	  pageTemplate.set("BODY", i, req);
	  pageTemplate.toHtml(pw, req);
      }
      
      try {
	  resp.flushBuffer();
      } catch (IOException e) {
	  Core.logger.log(this, "I/O error ("+e+
			  ") flushing buffer... probably harmless", e, Logger.MINOR);
      }
  }
  
  /**
   *  Gets the servletInfo attribute of the NodeInfoServlet object
   *
   * @return    The servletInfo value
   */
  public String getServletInfo() {
    return "Information on the nodes current internals.";
  }


  /**
   *  Gets the servletName attribute of the NodeInfoServlet object
   *
   * @return    The servletName value
   */
  public String getServletName() {
    return "Node Information";
  }


  /**
   *  Description of the Method
   *
   * @param  g  Description of the Parameter
   */
  private static void registerGroup(Group g) {
    groups.addElement(g);
    lookupTable.put(g.shortName, g);
  }


  /**
   *  Description of the Method
   *
   * @param  g  Description of the Parameter
   * @param  i  Description of the Parameter
   */
  private static void registerInfolet(Group g, Infolet i) {
    g.register(i);
    lookupTable.put(g.shortName + "/" + i.shortName(), i);
    i.init(node);
  }


  /**
   *  Description of the Class
   *
   * @author     ian
   * @created    August 27, 2002
   */
  private static class Group {
    /**  Description of the Field */
    public String longName;
    /**  Description of the Field */
    public String shortName;
    Vector infolets = new Vector();
    Hashtable lookupTable;


    /**
     *Constructor for the Group object
     *
     * @param  longName   Description of the Parameter
     * @param  shortName  Description of the Parameter
     */
    public Group(String longName,
        String shortName) {
      this.longName = longName;
      this.shortName = shortName;
    }


    /**
     *  Description of the Method
     *
     * @param  l  Description of the Parameter
     */
    public final void register(Infolet l) {
      infolets.addElement(l);
    }


    /**
     *  Description of the Method
     *
     * @param  pw           Description of the Parameter
     * @param  req  Description of the Parameter
     */
    public final void toHtml(PrintWriter pw,HttpServletRequest req) {
	 	StringWriter swGroup = new StringWriter(100);
	  	PrintWriter pwGroup = new PrintWriter(swGroup);
	  	boolean anyPrinted = false; 
	  	pwGroup.println("<B>" + longName + "</B><BR>");
      	for (Enumeration e = infolets.elements(); e.hasMoreElements(); ) {
        	Infolet l = (Infolet) e.nextElement();
        	// this should really check to see if the Node Status Servlet is running,
        	// but its not that easy to get a reference to MultipleHttpServletContainer
        	// to check whether the Serlvet will be run (it doesn't get run until the first
        	// access)
        	// anyone who turns nodestatus off in the config will know what they're doing
        	if(l.visibleFor(req)) {
				pwGroup.println("<li><a href=\"" + l.target(req.getServletPath(), shortName) +
	            	"\">" + l.longName() + "</a><br>");
				anyPrinted = true;
	        }
    	}
    	if(anyPrinted) {
    		pwGroup.flush();
    		pw.print(swGroup.getBuffer());
  		}
  	}
  }
}







