package freenet.message.client;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;
import java.io.InputStream;

/** FCP SHA1 hash command.
  */
public class GenerateSHA1 extends ClientMessage {

    public static final String messageName = "GenerateSHA1";

    public GenerateSHA1(ConnectionHandler source, RawMessage raw) {
        super(source, raw, true);
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing GenerateSHA1 message.")
            : (State) new NewGenerateSHA1(id, source);
    }

    public String getMessageName() {
        return messageName;
    }
}
