package freenet.message.client.FEC;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;
import freenet.message.client.ClientMessage;
import freenet.support.Fields;

/** Message to make SplitFile metadata from a list of 
 *  segment header, block map pairs.
 */
public class FECMakeMetadata extends ClientMessage {

    public static final String messageName = "FECMakeMetadata";

    private String description = null;
    private String mimeType = null;
    private String checksum = null;

    // From wire
    public FECMakeMetadata(ConnectionHandler source, RawMessage raw) {
        super(source, raw, true);
        try {
            description = otherFields.get("Description");
            mimeType = otherFields.get("MimeType");
            checksum = otherFields.get("Checksum");
        }
        catch (Exception e) {
            e.printStackTrace();
            formatError = true;
        }
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing FECMakeMetadata message.")
            : (State) new NewFECMakeMetadata(id, source);
    }

    public String getMessageName() {
        return messageName;
    }

    public final String getDescription() { return description; }
    public final String getMimeType() { return mimeType; }
    public final String getChecksum() { return checksum; }
}





