package freenet.message.client;
import freenet.*;
import freenet.node.State;
import freenet.node.Node;
import freenet.node.states.FCP.*;

/**
 * A request for the node to return diagnostics data.
 */

public abstract class AdminMessage extends ClientMessage {

    private String password;

    public AdminMessage(ConnectionHandler source, RawMessage message) {
        super(source, message);
        this.password = otherFields.get("Password");
    }
    
    public boolean isAuthorized() {
        return Node.isAuthorized(source.peerIdentity(),
                                 password);
    }
}
