package freenet.message;
import java.io.*;
import java.net.*;
import freenet.*;
import freenet.node.*;
import freenet.node.ds.KeyCollisionException;
import freenet.node.states.data.ReceiveData;
import freenet.support.*;
import freenet.support.io.DataNotValidIOException;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the DataReply message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 * @author oskar (rewritten from scratch... several times)
 **/

public class DataReply extends DataSend {

    public static final String messageName = "DataReply";

    
    public DataReply(long idnum,  
		     FieldSet fs, long length) throws UnknownHostException {
	
	super(idnum, fs, null, length);
    }

    // if we're creating a new DataReply, it's to send it,
    // so we cannot give it an InputStream
    //public DataReply(long idnum, FieldSet fs, InputStream data, long length)
    //       throws IOException {
    //super(idnum, fs, data, length);
    //}
    
    public DataReply(ConnectionHandler source, RawMessage raw)
	throws InvalidMessageException, BadAddressException {
	
	super(source, raw);	
    }

    public RawMessage toRawMessage(Presentation t) {
        RawMessage raw=super.toRawMessage(t);
        //raw.messageType="DataReply";
        return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    // index immediately
    //public ReceiveData cacheData(Node n, Key searchKey) 
    //        throws IOException, DataNotValidIOException, KeyCollisionException {
    //    return super.cacheData(n, searchKey, true);
    //}
}








