package freenet.message;
import freenet.*;

/**
 * This is a single hops message sent back to notify the node
 * from which an InsertRequest was received that it can go ahead
 * and send the data. 
 *
 * @author oskar
 */
public class Accepted extends NodeMessage {

    public static final String messageName = "Accepted";

    public Accepted(long idnum) {
	super(idnum, null);
    }

    public Accepted(ConnectionHandler source, 
                    RawMessage raw) throws InvalidMessageException {
	super(source, raw);
    }
    
    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw = super.toRawMessage(t);
	//raw.messageType=messageName;
	return raw;
    }
    
    public String getMessageName() {
        return messageName;
    }


}
