package freenet.fs.dir;

import freenet.support.*;
import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

import freenet.Core;

/**
 * Implementation of DataObjectStore with a Directory for the backing storage.
 * This is kind of sloppily done atm.
 * @author tavin
 */
public class FSDataObjectStore implements DataObjectStore {

    protected final LossyDirectory dir;

    protected final Hashtable dataObjects = new Hashtable();
    protected final Hashtable outputQueue = new Hashtable();
    

    public FSDataObjectStore(LossyDirectory dir) {
        this.dir = dir;
    }


    public synchronized void flush() throws IOException {
        synchronized (dir.semaphore()) {
	    if(Core.logger.shouldLog(Core.logger.DEBUG))
		Core.logger.log(this, "Flushing FSDataObjectStore", Core.logger.DEBUG);
            Enumeration keys = outputQueue.keys();
	    int x = 0;
            while (keys.hasMoreElements()) {
		x++;
                FileNumber key = (FileNumber) keys.nextElement();
                DataObject o = (DataObject) outputQueue.get(key);
                Buffer buffer = dir.forceStore(o.getDataLength(), key);
		DataOutputStream out;
		OutputStream os = null;
                try {
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Flushing " + key.toString() + 
					" to disk in FSDataObjectStore ("+x+
					")", Core.logger.DEBUG);
		    os = buffer.getOutputStream();
		    if(os == null) throw new DirectoryException
				       ("buffer returned no output streams: " +
					key.toString());
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Got output stream ("+x+")", Core.logger.DEBUG);
                    out = new DataOutputStream(os);
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Got data output stream ("+x+
					")", Core.logger.DEBUG);
                    o.writeTo(out);
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Written data ("+x+
					")", Core.logger.DEBUG);
                    out.close();
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Closed ("+x+")", 
					Core.logger.DEBUG);
		    dir.delete(key, false);
		    buffer.commit();
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Committed ("+x+")" + 
					key.toString() + 
					" in FSDataObjectStore", 
					Core.logger.DEBUG);
                }
                finally {
		    if(Core.logger.shouldLog(Core.logger.DEBUG))
			Core.logger.log(this, "Running finalizers for flush ("+
					x+")", Core.logger.DEBUG);
		    if(os != null) os.close();
                    buffer.release();
                }
            }
            outputQueue.clear();
            dir.forceFlush();
	    if(Core.logger.shouldLog(Core.logger.DEBUG))
		Core.logger.log(this, "Flushed FSDataObjectStore", 
				Core.logger.DEBUG);
        }
    }
    

    public DataObject get(FileNumber key) throws DataObjectUnloadedException {
        DataObject o = (DataObject) dataObjects.get(key);
        if (o == null) {
            Buffer buffer = dir.fetch(key);
            if (buffer == null)
                return null;  //buffer = new NullBuffer();
            throw new DataObjectUnloadedExceptionImpl(key, buffer);
        }
        return o;
    }

    protected class DataObjectUnloadedExceptionImpl extends DataObjectUnloadedException {
        
        final FileNumber key;
        final Buffer buffer;
        
        DataObjectUnloadedExceptionImpl(FileNumber key, Buffer buffer) {
            this.key = key;
            this.buffer = buffer;
        }

        public final int getDataLength() {
            return (int) buffer.length();
        }

        public final DataInputStream getDataInputStream() throws IOException {
            return new DataInputStream(buffer.getInputStream());
        }

        public final void resolve(DataObject o) {
            dataObjects.put(key, o);
            buffer.release();
        }
    }
    

    public void set(FileNumber key, DataObject o) {
	Core.logger.log(this, "Adding object to FSDataObjectStore", 
			Core.logger.DEBUG);
        dataObjects.put(key, o);
	Core.logger.log(this, "Added object to dataObjects", 
			Core.logger.DEBUG);
        outputQueue.put(key, o);
	Core.logger.log(this, "Added object to outputQueue",
			Core.logger.DEBUG);
    }

    public final boolean contains(FileNumber key) {
        return dataObjects.containsKey(key) || dir.contains(key);
    }

    public final boolean remove(FileNumber key) {
        boolean ret = false;
	Core.logger.log(this, "Removing "+key, Core.logger.DEBUG);
        if (null != dataObjects.remove(key)) ret = true;
	else Core.logger.log(this, key.toString()+" not in dataObjects",
			     Core.logger.DEBUG);
        if (null != outputQueue.remove(key)) ret = true;
	else Core.logger.log(this, key.toString()+" not in outputQueue",
			     Core.logger.DEBUG);
        if (dir.delete(key, false)) ret = true;
	else Core.logger.log(this, key.toString()+" not in underlying Dir",
			     Core.logger.DEBUG);
	Core.logger.log(this, "Remove "+key+" returning "+ret, 
			Core.logger.DEBUG);
        return ret;
    }

    protected int countKeys() {
	int x = 0;
	for(Enumeration e = dir.keys(true);e.hasMoreElements();
	    e.nextElement()) {
	    x++;
	}
	return x;
    }

    protected int countLRUKeys() {
	int x = 0;
	for(Enumeration e = dir.keys(true);e.hasMoreElements();
	    e.nextElement()) {
	    x++;
	}
	return x;
    }
    
    public final Enumeration keys(boolean ascending) {
        try {
            flush();
        }
        catch (IOException e) {
            // bah
        }
        return dir.keys(ascending);
    }

    public final Enumeration keys(FileNumber start, boolean ascending) {
	// FIXME!
	throw new UnsupportedOperationException("not implemented");
    }

    public final Enumeration keys(FilePattern pat) {
        try {
            flush();
        }
        catch (IOException e) {
            // bah
        }
        return dir.keys(pat);
    }
}


