package freenet.fs.acct;

import java.util.Enumeration;

public final class BlockList {

    private int[] blocks;
    private int count;

    public BlockList() {
        this(4);
    }

    public BlockList(int initialCapacity) {
        blocks = new int[((initialCapacity + 3) >> 2) << 2];
        count = 0;
    }

    public BlockList(int initialCapacity, Enumeration be) {
        this(initialCapacity);
        while (be.hasMoreElements())
            push(((BlockElement) be.nextElement()).getBlockNumber());
    }

    public BlockList(BlockList ancestor) {
        this.blocks = new int[ancestor.blocks.length];
        System.arraycopy(ancestor.blocks, 0, this.blocks, 0, this.blocks.length);
        this.count = ancestor.count;
    }
    

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        if (count > 0) {
            sb.append(blocks[0]);
            for (int i=1; i<count; ++i)
                sb.append(',').append(blocks[i]);
        }
        return sb.toString();
    }
    
    public final void push(int bnum) {
        if (count == blocks.length) {
            int[] b = new int[blocks.length + 4];
            System.arraycopy(blocks, 0, b, 0, blocks.length);
            blocks = b;
        }
        blocks[count++] = bnum;
    }

    public final int pop() {
        return count == 0 ? -1 : blocks[--count];
    }

    public final int peek() {
        return count == 0 ? -1 : blocks[count-1];
    }

    public final int[] blocks() {
        int[] ret = new int[count];
        System.arraycopy(blocks, 0, ret, 0, count);
        return ret;
    }

    public final int count() {
        return count;
    }

    public final void clear() {
        count = 0;
    }
}


