package freenet.fs.acct;

import java.io.IOException;

/**
 * Thrown for I/O errors that occur inside a method that is not
 * allowed to throw an IOException.
 */
public class AccountingIOException extends AccountingException {

    private final IOException src;

    public AccountingIOException(IOException src) {
        super(src.toString());
        this.src = src;
    }

    public final IOException getIOException() {
        return src;
    }
}


