package freenet.diagnostics;
import java.util.Enumeration;
/**
 * The fields I need in the objects I list events. 
 *
 * @author oskar
 */

interface EventList {

    /**
     * Called before reading and writing starts to an eventlist.
     * @param  rv  The RandomVar that contains this list.
     */
    public void open(RandomVar rv);

    /**
     * Called after reading and writing to an eventlist is done.
     */
    public void close();

    /**
     * Adds a VarEvent first (previous to anything else).
     */
    public void addFirst(VarEvent ve);

    /**
     * Adds a VarEvent last (latest).
     * This is equivalent to ....insertNext(....getLast(), ...)
     */
    public void addLast(VarEvent ve);

    /**
     * Adds a VarEvent after one that is already in the list.
     * @param at   The VarEvent to insert by.
     * @param ve   The VarEvent to add.
     */ 
    public void insertNext(VarEvent at, VarEvent ve);

    /**
     * Returns the first VarEvent in the list.
     */
    public VarEvent getFirst();

    /**
     * Returns the last element in the list
     */
    public VarEvent getLast();
    
    /**
     * Removes the first element in the list.
     * @return The element the 
     */
    public VarEvent removeFirst();
    
    /**
     * Enumerates the elements from first to last.
     */
    public Enumeration elements();

    /**
     * Enumerates the elements from last to first.
     */
    public Enumeration reverseElements();

    /**
     * A String from which this list can be restored after the node has
     * restarted.
     */
    public String restoreString();
}



