package freenet.diagnostics;
import freenet.support.Fields;
import freenet.FieldSet;
import java.util.Enumeration;
import java.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
/**
 * Implementation of a the binomial random var.
 *
 * @author oskar
 */


class Binomial extends RandomVar {

    public static long VERSION = 2;

    static {
        try {
            RandomVar.registerType("Binomial", RandomVar.class);
        } catch (NoSuchMethodException e) {
        }
    }
    
    public Binomial(StandardDiagnostics sd, String name, int period, 
                    String comment) {
        super(sd, name, period, comment);
    }

    public String getType() {
        return "Binomial";
    }
    
    public void add(long time, long n, long x, long lasttime) {
        super.add(new BinomialVarEvent(time, n, x), lasttime);
    }
    
    public void add(BinomialVarEvent e, long lasttime) {
        super.add(e, lasttime);
    }
    
    public VarEvent aggregate(EventList ll, long time, long after) {
        long tx = 0, tn = 0;


        for (Enumeration e = ll.elements() ; 
             e.hasMoreElements();) {
            BinomialVarEvent bve = (BinomialVarEvent) e.nextElement(); 
            if (bve.time() > after) {
                if (bve.time() > time)
                    break;
                tn += bve.n;
                tx += bve.x;        
            }
        }
        return new BinomialVarEvent(time, tn, tx);
    }

    public VarEvent readEvent(DataInputStream in) throws IOException {
        long version = in.readLong();
        long time = (version > StandardDiagnostics.y2k ? version : in.readLong());
        long n = in.readLong();
        long x = in.readLong();
        return new BinomialVarEvent(time, n, x);
    }

    public String[] headers() {
        return new String[] { "Tries" , "Successes", "Ratio" };
    }
}

