package freenet.crypt;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/
import java.io.*;
import java.math.BigInteger;
import java.util.Stack;
import java.util.Random;
import freenet.support.*;
import freenet.*;

public class DiffieHellman {
    private static final int PRECALC = 15;
    private static Random r = Core.randSource;
    private static DHGroup group = Global.DHgroupA;
    private static Stack precalcBuffer = new Stack();

    private static Thread precalcThread;

    static {
        precalcThread = new PrecalcBufferFill();
        precalcThread.start();
    }

    private static class PrecalcBufferFill extends Thread {
	
	public PrecalcBufferFill() {
	    setName("Diffie-Helman-Precalc");
	    setDaemon(true);
	}

	public void run() {
	    while (true) {
                while (precalcBuffer.size() < PRECALC) {
                    precalcBuffer.push(genParams());

                    synchronized (precalcBuffer) {
                        // notify a waiting thread, that new data is 
                        // available
                        precalcBuffer.notify();
                    }
		}
                
                synchronized (precalcBuffer) {
                    // we have to check this, after having synchronized,
                    // because the precalcBuffer migt have changed.
                    while (precalcBuffer.size() >= PRECALC) {
                        try {
                            this.setPriority(MIN_PRIORITY); 
                            precalcBuffer.wait(200);
                        } catch (InterruptedException ie) {}
                    } 
                }
	    }
	}
    }

    public static void init() {
        // This method does not do anything, but calling it, causes
        // the PrecalcBufferFill thread to be started.
    }

    public static BigInteger[] getParams() {
        synchronized(precalcBuffer) {
            if (precalcBuffer.isEmpty()) {
                precalcThread.setPriority(Thread.MAX_PRIORITY);
            }

            while (precalcBuffer.isEmpty()) {
                try {
                    precalcBuffer.wait(200);
                } catch (InterruptedException e) {}
            }

            BigInteger[] result = (BigInteger[]) precalcBuffer.pop();
            // notify thread, that a value is removed.
            precalcBuffer.notify();
            return result;
           
        }
    }

    private static BigInteger[] genParams() {
	BigInteger params[]=new BigInteger[2];
	params[0]=new BigInteger(256,r);
	params[1]=group.getG().modPow(params[0], group.getP());
	return params;
    }

    public static DHGroup getGroup() {
	return group;
    }
}
