package freenet.client.listeners;
import java.util.Vector;
import java.util.Enumeration;
import freenet.client.ClientEventListener;
import freenet.client.ClientEvent;
/**
 * A ClientEventListener that collects the events and returns them as an
 * enumeration.
 *
 * @author oskar
 */

public class CollectingEventListener implements ClientEventListener {
    
    private final Vector events;
    private final int maxLength;
    
    public CollectingEventListener() {
        events = new Vector();
	maxLength = -1;
    }
    
    public CollectingEventListener(int maxLength) {
	this.maxLength = maxLength;
	events = new Vector(maxLength+1);
    }
    
    public void receive(ClientEvent ce) {
        events.addElement(ce);
	if(maxLength > 0 && events.size() > maxLength)
	    events.removeElementAt(0);
    }
    
    public Enumeration events() {
        return events.elements();
    }
    
    public Vector asVector() {
	return events;
    }
}
