package freenet.client;
import freenet.client.listeners.DoneListener;
import freenet.client.listeners.CollectingEventListener;
import freenet.client.metadata.Metadata;
import freenet.client.metadata.MetadataSettings;
import freenet.client.metadata.DocumentCommand;
import freenet.client.metadata.InvalidPartException;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.ArrayBucket;
import freenet.support.io.DataNotValidIOException;
import freenet.client.events.GeneratedURIEvent;
import freenet.client.events.RedirectFollowedEvent;
import freenet.client.events.StateReachedEvent;
import freenet.client.events.ExceptionEvent;
import freenet.client.events.ErrorEvent;
import freenet.client.events.DocumentNotValidEvent;
import freenet.client.events.DataNotFoundEvent;
import java.io.IOException;
import java.util.Vector;
import freenet.Core; // for logging
import freenet.support.Logger;
/**
 * Handeles a series of requests to fill a bucket by traversing down
 * metadata redirections.
 *
 * @author oskar
 */
public class GetRequestProcess extends ControlRequestProcess {

    private Bucket metadataBucket;
    
    private CollectingEventListener cel;
    
    public GetRequestProcess(FreenetURI uri, int htl, Bucket data,
                             BucketFactory ptBuckets, int recursionLevel,
                             boolean follow, MetadataSettings msettings) {
        super(uri, htl, data, ptBuckets, recursionLevel, follow,
              msettings);
    }


    public GetRequestProcess(FreenetURI uri, int htl, Bucket data,
                             BucketFactory ptBuckets, int recursionLevel,
                             MetadataSettings msettings) {
        super(uri, htl, data, ptBuckets, recursionLevel, true,
              msettings);
    }

    public synchronized Request getNextRequest() {
	boolean logDEBUG = Core.logger.shouldLog(Logger.DEBUG);
	if(logDEBUG) 
	    Core.logger.log(this, "In getNextRequest() for "+this, Logger.DEBUG);
        if (aborted || failed) {
	    if(logDEBUG) Core.logger.log(this, "Failed or aborted: "+this, Logger.DEBUG);
            return null;
	}
	if (dl == null) {
	    if(logDEBUG)
		Core.logger.log(this, "Creating first request in getNextRequest for "+
				this, Logger.DEBUG);
            metadataBucket = new ArrayBucket();
            //System.err.println("LALA REQUESTING URI: " + uri);
            r = new GetRequest(htl, uri, metadataBucket, data, msettings.isNonLocal());
            dl = new MyListener();
	    if(Core.logger.shouldLog(Logger.NORMAL))
		cel = new CollectingEventListener(16);
	    r.addEventListener(dl);
	    if(cel != null) r.addEventListener(cel);
            return r;
        } else {
	    if(logDEBUG) Core.logger.log(this, "Not first request for "+this,
					 Logger.DEBUG);
            if (!nextLevel) {
		if(logDEBUG)
		    Core.logger.log(this, "Waiting for completion for "+this,
				    Logger.DEBUG);
                dl.strongWait();
		if(logDEBUG)
		    Core.logger.log(this, "Completed for "+this,
				    Logger.DEBUG);
		//if(aborted) return null; - this would leave a Client running...
                nextLevel = true;
                if (r.state() == r.DONE) {
                    try {
                        //System.err.println("QUACK: " + msettings);
			if(logDEBUG)
			    Core.logger.log(this, "Raw Metadata:\n"+metadataBucket.
					    toString(), Logger.DEBUG);
                        metadata = 
                            new Metadata(metadataBucket.getInputStream(),
                                         msettings);
			if(logDEBUG)
			    Core.logger.log(this, "Processed Metadata for "+this+":\n"+
					    metadata.writeString(), Logger.DEBUG);
                        // Extract the checksum CHK from the info part.
                        // If more than one value is specified, we
                        // favor the one that is closest to the end
                        // of the redirect chain.
                        //
                        // I did this so that people can't create 
                        // redirects with "corrected" checksum values.
                        // --gj
                        String checksum = metadata.getChecksum(null);
                        if (checksum != null) {
                            msettings.setChecksum(checksum);
                        }
                        //System.err.println("LALA GOT MD: " + metadata);
                        if (follow) {
                            //System.err.println("GRP L: " +
                            //                   recursionLevel + 
                            //                   " uri: " + uri);
                            String mds = uri.getMetaString();
                            DocumentCommand d = (mds == null ? 
                                                 null : 
                                                 metadata.getDocument(mds));
                            FreenetURI nuri;
                            if (d != null) {
                                nuri = uri.popMetaString();
                            } else {
                                d = metadata.getDefaultDocument();
                                nuri = uri;
                            }
                            //System.err.println("GRP L: " +
                            //                   recursionLevel + 
                            //                   " d: " + d + 
                            //                   " mds: " + mds);
                            
                            if (d != null) {
				r.produceEvent(new RedirectFollowedEvent(d.getControlPart()));
                                next = d.getGetProcess(nuri, htl, data, 
                                                       ptBuckets, 
                                                       recursionLevel, 
                                                       msettings);
			    }

                            if (next == null && mds != null) {
                                // there was a metastring left, and
                                // there are no more control documents
                                // to apply it to.
				error = "Key not found in manifest";
				origThrowable = new 
				    KeyNotInManifestException();
                                failed = true;
                                return null;
                            }
                        }
                    } catch (IOException e) {
                        return null;
                    } catch (InvalidPartException e) {
                        return null;
                    } 
                } else {
                    failed = true;
		    if(error != null && !error.equals("")) {
			if(aborted) {
			    error = "Request for " + getURI() + " aborted!";
			} else {
			    error = "Request for " + getURI() + " failed.";
			}
		    }
		    
		    if(origThrowable != null)
			error += ": "+origThrowable;
		    
		    if(cel != null) {
			Vector v = cel.asVector();
			if(v.size() > 0) {
			    int x = v.size()-1;
			    boolean explained = false;
			    while(x>=0) {
				ClientEvent ce = (ClientEvent)(v.elementAt(x));
				x--;
				Core.logger.log(this, "Event: "+ce.getDescription()
						+" for "+this+" before failure",
						Logger.NORMAL);
				if((!explained) && 
				   !(ce instanceof StateReachedEvent)) {
				    explained = true;
				    error += ": "+ce.getDescription();
				    if(ce instanceof ExceptionEvent)
					origThrowable = ((ExceptionEvent)ce).
					    getException();
				}
			    }
			}
		    }
		    
		    if(origThrowable == null) 
			origThrowable = 
			    new WrongStateException(error, r.DONE, r.state());
		    
                    return null;
                }
            }
            if (next != null) {
                Request rr = next.getNextRequest();
                failed = next.failed();
		if(failed) {
		    if(next.getThrowable() == null && next.getError() == null)
			Core.logger.log(this, "GRRRR! Both getThrowable "+
					"AND getError return null on "+next+
					" for "+this+": PLEASE REPORT TO "+
					"devl@freenetproject.org", 
					Logger.ERROR);
		    error = getNextFailedErrorString(next.getThrowable(),
						     next.getError());
		    origThrowable = next.getThrowable();
		}
                return rr;
            } else
                return null;
        }
    }
    
    class MyListener extends DoneListener {
	public void receive(ClientEvent ce) {
	    if(ce instanceof ExceptionEvent) {
		origThrowable = ((ExceptionEvent)ce).getException();
		if(Core.logger.shouldLog(Logger.MINOR))
		    Core.logger.log(this, GetRequestProcess.this.toString()+
				    ": "+ce.getDescription(), 
				    origThrowable, Logger.MINOR);
	    } else if(ce instanceof ErrorEvent) {
		error = ce.getDescription();
		Core.logger.log(this, GetRequestProcess.this.toString()+
				": "+ce.getDescription(), Logger.NORMAL);
	    } else if(ce instanceof DocumentNotValidEvent) {
		origThrowable = ((DocumentNotValidEvent)ce).getDNV();
		if(Core.logger.shouldLog(Logger.MINOR))
		    Core.logger.log(this, GetRequestProcess.this.toString()+
				    ": "+ce.getDescription(), origThrowable,
				    Logger.MINOR);
	    } else if(ce instanceof DataNotFoundEvent) {
		cel = null;
	    } // RouteNotFound DOES trigger an event dump
	    super.receive(ce);
	}
    }
}





