package freenet;

import java.util.Hashtable;
import freenet.session.*;
//import freenet.node.NodeReference; // I don't like importing this here, but wtf

/**
 * The peer class represents a single route of contact to a peer.
 *
 * @author oskar
 */
public class Peer {

    private Identity id;
    private Address addr;
    private LinkManager lm;
    private Presentation p;

    public Peer(Identity id, Address addr, LinkManager lm, Presentation p) {
        this.id = id;
        this.addr = addr;
        this.lm = lm;
        this.p = p;
    }

    public Identity getIdentity() {
        return id;
    }

    public Address getAddress() {
        return addr;
    }

    //public NodeReference getNodeReference() {
    //    return new NodeReference(this, null, null);
    //}

    public LinkManager getLinkManager() {
        return lm;
    }

    public Presentation getPresentation() {
        return p;
    }

    public boolean equalsIdent(Peer p) {
        return p != null && id.equals(p.id);
    }

    public boolean equalsIdent(Identity id) {
        return id != null && this.id.equals(id);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Peer [");
        sb.append(id).append(" @ ");
        sb.append(addr).append(" (");
        sb.append(lm.designatorNum()).append('/');
        sb.append(p.designatorNum()).append(")]");
        return sb.toString();
    }
}

    
    
