package freenet;
import freenet.thread.ThreadFactory;
import freenet.node.Main;
import freenet.node.NodeReference;
import freenet.session.*;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.LRUQueue;
import freenet.support.io.NIOInputStream;
import freenet.transport.tcpConnection;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Enumeration;
import java.util.Date;
import java.io.OutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

//import sun.rmi.transport.proxy.HttpReceiveSocket;

//import javax.security.auth.callback.TextOutputCallback;
/**
 * I moved out of the LinkManager code because I think that the 
 * crypto links and open ConnectionHandlers are fairly orthogonal.
 * Yeah, it means Another Fucking Hashtable (AFH (tm)), but the other
 * way was another fucking headache, and I've had enough of those too.
 *
 * Anyways, the job of this class is pretty obvious - it caches open
 * and active ConnectionHandler objects.
 *
 * @author oskar
 */

public final class OpenConnectionManager {

    private final ThreadFactory tf;
    private final MultiValueTable chs;
    private int openConns;
    
    private final LRUQueue lru = new LRUQueue();
    private int maxConnections = -1;
    
	private boolean useOldStyle = false; //Keep track of what HTML mode the user last requested
	private int viewLevel = 0;
	private int iSortingMode = 0;
	private NumberFormat nf = NumberFormat.getInstance();

    public OpenConnectionManager(ThreadFactory tf, int maxConnections) {
        this.tf = tf;
        this.maxConnections = maxConnections;

        chs = new MultiValueTable(50, 3);
        openConns = 0;
    }

    /**
     * This method is package only, meant only for ConnectionHandler
     * objects to add themselves.
     */
    void put(ConnectionHandler ch) {
        synchronized (this) {
            //if (ch.peerIdentity() == null) return;
            chs.put(ch.peerIdentity(), ch);
            //        v.addElement(ch);
            lru.push(ch); // hmmm nested locks
            Core.diagnostics.occurrenceCounting("liveConnections",1);
            if (ch.outbound && (Core.outboundContacts != null)) {
                // We really mean live, not active.  Some of the 
                // "active" connections may be idle.
                Core.outboundContacts.incActive(ch.peerAddress().toString());
                Core.outboundContacts.incSuccesses(ch.peerAddress().toString());
            }
            
            openConns++;
        }

        // Dump LRU idle connection.
        //
        // Note: You don't want to dump the simple LRU connection
        //       because under heavy load the LRU connections are
        //       the ones that are transferring data.
        //       
        ConnectionHandler oldest = null;
	while (true) {
	    synchronized (lru) {
		
		if (maxConnections > 0 && lru.size() > maxConnections) {
		    
		    // Dump an idle connection if possible.
		    for (Enumeration e = lru.elements(); e.hasMoreElements();) {
			ConnectionHandler candidate = 
			    (ConnectionHandler)e.nextElement();
			if (!(candidate.sending() || candidate.receiving())) {
			    oldest = candidate;
			    //lru.remove(candidate);
			    break; // We have a winner.
			}
		    }
		    if (oldest == null) {
			// Not good. This connection will most likely
			// be restarted, causing even more traffic :-(
                        //System.err.println("!KILLED OPEN CONNECTION!");
			oldest = (ConnectionHandler)lru.pop();
		    }
		    
		} else break; // break outer loop - we have killed enough connections
	    }
	    if (oldest != null) {
		Core.diagnostics.occurrenceBinomial("connectionTimedout", 1, 0);
		oldest.terminate();
	    }
	}
    }
    
    // Removing a connection that isn't in the OCM is a 
    // legal NOP.
    synchronized ConnectionHandler remove(ConnectionHandler ch) {
        //if (ch.peerIdentity() == null) return null;
        if (chs.removeElement(ch.peerIdentity(), ch)) {
	    if(Core.logger.shouldLog(Core.logger.DEBUG))
		Core.logger.log(this, "Removed ConnectionHandler " + 
				ch, new Exception ("debug"), 
				Core.logger.DEBUG);
            Core.diagnostics.occurrenceCounting("liveConnections",
						-1);
	    
            if (ch.outbound && (Core.outboundContacts != null) && ch.peerAddress() !=null) {
                Core.outboundContacts.decActive(ch.peerAddress().toString());
            }
            lru.remove(ch);
            openConns--;
            return ch;
        } else
            return null;
    }

    /**
     * This will return an open and not busy ConnectionHandler to the 
     * node identified.
     */
    private synchronized ConnectionHandler findFreeConnection(Identity id) {
        for (Enumeration e = chs.getAll(id) ; e.hasMoreElements() ; ) {
            ConnectionHandler res = (ConnectionHandler) e.nextElement();
            if (!res.isOpen()) {
                //  System.err.println("ConnectionHandlers ARE LEAKING! (0)");

                //                  Core.logger.log(this, "ConnectionHandlers are leaking:"
                //                                  + res,
                //                                  Core.logger.MINOR);
                
                // BUG? This doesn't look right.  Won't remove() be called
                // when the leaked connection handler is finalized?
                Core.diagnostics.occurrenceCounting("liveConnections",
                                                   -1);
                if (chs.removeElement(id, res)) {
                    openConns--;
                    lru.remove(res);
                }
            } else if (!res.sending()) {
                // found one
                lru.push(res);
                // Mark this connection as cached
                // so we know to discount it in 
                // connection success accounting in 
                // the Routing implementation.
                res.setCached(true);
                return res;
            }
        } 
        return null;
    }

    /**
     * This attempts to search for the open connection to id best suited for
     * sending a message. The formula for this is the connection with the 
     * smallest value of sendQueueSize() divided by the preference value of
     * the transport.
     */
    private synchronized ConnectionHandler findBestConnection(Identity id) {
        ConnectionHandler res, best = null;
        double resval, bestval = Double.POSITIVE_INFINITY;
        for (Enumeration e = chs.getAll(id) ; e.hasMoreElements() ; ) {
            res = (ConnectionHandler) e.nextElement();
            if (!res.isOpen()) {
                //                  System.err.println("ConnectionHandlers ARE LEAKING!(1)");
                //                  Core.logger.log(this, "ConnectionHandlers are leaking",
                //                                  Core.logger.MINOR);
                if (chs.removeElement(id, res))  {
                    openConns--;
                    lru.remove(res);
                }
            } else {
                resval = res.sendQueueSize() / 
                    res.transport().preference();
                
                if (resval < bestval) {
                    bestval = resval;
                    best = res;
                }                           
            }
        }
        return best;
    }

    /**
     * Creates a new Connection which is started and added.
     * @param c     The Core to connect from
     * @param p     The Peer to connect to
     * @param long  The  number of millisseconds before returning 
     *              ConnectFailedException - this does not necessarily
     *              mean that it won't eventually succeed, but we some
     *              threads may not wish to hang around to find out.
     * @return   A running ConnectionHandler
     * @exception  ConnectFailedException  if the connection fails or 
     *                                     timeout runs out.
     */ 
    public ConnectionHandler createConnection(Core c, Peer p, long timeout) 
                                            throws CommunicationException {

        ConnectionHandler ret = null;
        ConnectionJob ct = new ConnectionJob(c, p);
        synchronized (ct) {
            tf.getThread(ct);
            //tm.forceRun(ct);
            // Restored pooled threads (oskar 20020204)
            //Thread job = new Thread(ct, 
            //                        "Non-pooled connection thread: " 
            //                        + p.getAddress().toString());
            //job.start();


          
            long endtime = System.currentTimeMillis() + timeout;

            while (!ct.done) {
                try {
                    if (timeout == 0) {
                        ct.wait(5*60*1000);
                    }
                    else {
                        long wait = endtime - System.currentTimeMillis();
                        if (wait <= 0) break;
                        ct.wait(wait);
                    }
                }
                catch (InterruptedException e) {}
            }
            
            if (ct.ch != null) {
                Core.diagnostics.occurrenceBinomial("connectionRatio",1,1);
                ret = ct.ch;
            } else if (ct.e == null) {
                Core.diagnostics.occurrenceBinomial("connectionRatio",1,0);
                if (timeout == 0) {
                    Core.logger.log(this, "Something is very wrong new " + 
                                    "connections for "+ct+". Waited 5 minutes",
                                    Logger.ERROR);
                }
		ConnectFailedException e = 
		    new ConnectFailedException(p.getAddress(), 
					       p.getIdentity(),
					       "Timeout reached while waiting",
					       true);
		Core.logger.log(this, "Failed to connect on "+ct.ch+" with "+
				ct, e, Logger.DEBUG);
                throw e;
            } else {
                Core.diagnostics.occurrenceBinomial("connectionRatio",1,0);
                throw ct.e;
            }
        }
        
        if (ret != null) {
            return ret;
        }
        
        throw new RuntimeException("Assertion Failure: ret != null");
    }

    /**
     * Returns a free connection, making a new one if none is available.
     */
    public ConnectionHandler getConnection(Core c, Peer p, long timeout) 
                                        throws CommunicationException {

        // Let the race begin!
        // If non-null it was open and free when findFreeConnection returned
        // but nothing guarantees that some other thread won't have sent a
        // message with a huge trailing field by the time you actually
        // try to send a message on it.
        ConnectionHandler ch = findFreeConnection(p.getIdentity()); 

        if (ch == null) {
            ch = createConnection(c, p, timeout);
        }
        return ch;
    }

    /**
     * Gives the number of registered open connections.
     */
    public final int countConnections() {
        return openConns;
    }
    
    private String timeFromMillis(long millis,boolean bMinutes,boolean bSeconds)
    {
    	String sRetval=null;
    	long minutes = Math.round(Math.floor(millis /60000));
    	long seconds = Math.round(Math.floor((millis-minutes*60000)/1000));
    	if(minutes >0 && bMinutes)
    		sRetval = String.valueOf(minutes);
    	if(bSeconds)
    		if(sRetval != null)
    		
				sRetval += ":"+(seconds<10?("0"+seconds):String.valueOf(seconds));
			else
				sRetval = seconds +" s";
		
		return sRetval==null?"":sRetval;
		 
    }
    
	private String format(long bytes) {
			if (bytes == 0) return "None";
			
			if (bytes>(2<<22)) return nf.format(bytes>>20) + " MiB";
			if (bytes>(2<<12)) return nf.format(bytes>>10) + " KiB";
			return nf.format(bytes) + " Bytes";

	}

     /**
     * Writes an HTML table with information about the open connections.
     *@param  pw			A destination to write the HTML output to
     *@param  iSortingMode	An optional column to sort on (0 -> natural LRU ordering of elements)
     *@param  servletPath	A string containing the path to the servlet that contains this data (SCRIPT_NAME).
     *@param  setMode		"new"|"old" Switches this OCM:s web interface between text only mode and graphical mode
     */
	public void writeHtmlContents(PrintWriter pw,HttpServletRequest req) {
		//int iSetSorting = 0;
		//try{
		//	if(req.getParameter("setSorting")!=null)
		//		req.getSession().setAttribute("OCMSortingMode",new Integer(req.getParameter("setSorting")));
		//}catch(NumberFormatException e){/*iSorting=0;*/}
		
		if(req.getParameter("setMode") != null) //Check for modeswitch
			if(req.getParameter("setMode").compareTo("old") ==0)
				useOldStyle = true;
			else
				useOldStyle = false;

		if(req.getParameter("setSorting")!= null){
			try{
				iSortingMode = Integer.parseInt(req.getParameter("setSorting"));//(req.getSession().getAttribute("OCMSortingMode")==null)?0:((Integer)req.getSession().getAttribute("OCMSortingMode")).intValue(); //TODO: catch casting errors
			}catch(NumberFormatException e){/*iSorting=0;*/}
		}
		if(req.getParameter("setLevel")!= null)
			try{
				viewLevel = Integer.parseInt(req.getParameter("setLevel"));
			}catch(NumberFormatException e){}
			
				
		StringBuffer buffer = new StringBuffer();
		String sep = "</td><td>";
		String sepAlignRight = "</td><td align = 'right'>";
		String sepAlignCenter = "</td><td align = 'center'>";
		String repetition ="<center>^^^</center>";
		int outbound = 0;
		int outboundNotInRoutingtable=0;
		int inbound = 0;
		long queueSize = 0;
		int sending = 0;
		int receiving = 0;
		List lConnections = new LinkedList();
		synchronized(this) { //DO NOT synchronize all of this method, only synchronize what is necessary. Any pw.print calls might deadlock since the NIOOS:s might call this.remove()
			for (Enumeration e = lru.elements() ; e.hasMoreElements() ;)
				lConnections.add(e.nextElement()); //Extract the ConnectionHandlers so that we can sort them if we want to
		}
		
		//Build a sorter and sort
		ConnectionHandlerComparator sorter = null;
		if(!useOldStyle){ //Magically mutate the requested sorting in certain circumstances. Would be better if the iSortingMode parameter could be an vector of intergers specifying the full sorting strategy 
			if(Math.abs(iSortingMode) == 9) //Special case if we are sorting on the link-icon. Sort first by in/out and then by sending and then bu receiving
				sorter = new ConnectionHandlerComparator(iSortingMode,new ConnectionHandlerComparator(-10,new ConnectionHandlerComparator(-5)));
			if(Math.abs(iSortingMode) == 11&& viewLevel ==0)
				sorter = new ConnectionHandlerComparator(iSortingMode,new ConnectionHandlerComparator(2));
		}
		if(sorter == null)
			sorter = new ConnectionHandlerComparator(iSortingMode);
		Collections.sort(lConnections,sorter);
	
		Iterator it=lConnections.iterator();
		ConnectionHandler chPrev = null; //To be able to indicate repetitions
		while(it.hasNext())
		{
			ConnectionHandler ch = (ConnectionHandler) it.next();
                        buffer.append("\n<tr>");
			
			if(!useOldStyle)
			{
				buffer.append("<td>");
				String imageURL = "/servlet/images/aqua/arrow";
				if(ch.outbound)	imageURL += "_outbound";
				else imageURL += "_inbound";
				if(ch.receiving() && ch.sending()) //Can this happen yet?
					imageURL += "_both";
				else
					if(ch.receiving()) imageURL += "_receiving";
					else if(ch.sending()) imageURL += "_transmitting";
						else imageURL += "_sleeping";
				imageURL += ".png";
				buffer.append("<center><img src='"+imageURL+"' height = '15' width = '24'></center></td>");
			}
			NodeReference n = Main.node.rt.getNodeReference(ch.peerIdentity());
			NodeReference nPrev = (chPrev==null)?null:Main.node.rt.getNodeReference(chPrev.peerIdentity());
			String s;

			if(n == null){
			    s = "not in RT";
				if(ch.outbound) outboundNotInRoutingtable++;
			}else if(n.physical.length == 0)
			    s = "no addresses";
			else
			    s = n.physical[1]; //physical[even] contains something like 'tcp', physical[odd] contains the associated address

			if(useOldStyle || viewLevel >0){
				buffer.append("<td>"+((chPrev != null && (chPrev.peerAddress().toString().compareTo(ch.peerAddress().toString())==0))?repetition:ch.peerAddress().toString()));
                                buffer.append(sep+((nPrev != null && n != null && nPrev.equals(n))?repetition:s));
			}else
				buffer.append("<td align = 'right'>"+(n==null?"<font color = #555555>"+ch.peerAddress().toString()+"</font>":s));
			
			
			
			if(useOldStyle || viewLevel >0)
				buffer.append(sep+((chPrev != null && chPrev.peerIdentity()==ch.peerIdentity())?repetition:ch.peerIdentity().toString().replaceAll(" ","&nbsp;")));
			            
			//int x = ch.sendingCount();
			//if(x > 0) sending++;;
			//buffer.append(ch.sendingCount() + sep); Remove until there can actually be other values than 0 and 1 here 
			if(ch.sending()){
				sending++;
				buffer.append(sepAlignRight+((useOldStyle || viewLevel>0)?String.valueOf(ch.sendQueueSize()):format(ch.sendQueueSize())));
				queueSize += ch.sendQueueSize();
			}else
				buffer.append(sepAlignRight+"-");
			if(ch.receiving())
				receiving++;
			
			if(useOldStyle)
				if(ch.receiving())
					buffer.append(sepAlignRight+"yes");
				else
					buffer.append(sepAlignRight+"no");

			buffer.append(sepAlignRight+ch.messages());
			
			if(useOldStyle){
				buffer.append(sepAlignRight + ch.idleTime());
				buffer.append(sepAlignRight + ch.runTime());
			}else{
				buffer.append(sepAlignCenter + timeFromMillis(ch.idleTime(),true,true));
				buffer.append(sepAlignCenter + timeFromMillis(ch.runTime(),true,true));
			}
			
			if(ch.outbound) {
				outbound++;
				if(useOldStyle)
					buffer.append(sep+"Outbound");
			} else {
				inbound++;
				if(useOldStyle)
					buffer.append(sep+"Inbound");
			}
			            
                        buffer.append("</td></tr>");
			chPrev = ch;
		}
        
		
		if(useOldStyle) {
			pw.println("<h2>Fred OpenConnectionManager Contents <font size = 1><A HREF = '"+req.getRequestURI()+"?setMode=new'>[Switch to graphical mode]</A></font></h2>");
			pw.println("<b>At date: " + new Date()+"</b><br>");
			pw.println("<br>Number of open connections: " + lru.size());
			pw.println("<br>Number of outbound connections: " + outbound);
			pw.println("<br>Number of inbound connections: " + inbound);
			pw.println("<br>Number of connections sending messages: "+sending);
			pw.println("<br>Number of connections receiving messages: "+receiving);
			pw.println("<br>Bytes waiting to be sent: " + queueSize);
			pw.println("<br>Outbound connections that are to peers not in the routingtable: "+100*(new Float(outboundNotInRoutingtable).floatValue()/new Float(outbound).floatValue())+"%");
		}else{
			pw.println("<h2>Open connections <font size = 1><A HREF = '"+req.getRequestURI()+"?setMode=old'>[Switch to text only mode]</A></font></h2>");
			pw.println("<b>"+new Date()+"</b><br>");
			pw.println("<table><tr><td>");
			//pw.println("<b>Connection status</b>");
                        pw.println("<table border=0 cellspacing = 1>\n");
			pw.println("<tr><td>Connections&nbsp;open&nbsp;(Inbound/Outbound/Limit)</td><td width =10></td><td>" + (inbound+outbound)+"&nbsp;("+inbound+"/"+outbound+"/"+maxConnections+")</td></tr>");

			pw.println("<tr><td>Connections&nbsp;transferring&nbsp;(Receiving/Transmitting)</td><td width =10></td><td>" +(receiving+sending)+"&nbsp;("+receiving+"/"+sending+")</td></tr>");
			pw.println("<tr><td>Bytes waiting to be sent</td><td width =10></td><td>" + format(queueSize)+"</td></tr>");
			if(viewLevel>0) {
				pw.println("<tr><td>Outbound&nbsp;connections&nbsp;that&nbsp;are&nbsp;to&nbsp;peers&nbsp;not&nbsp;in&nbsp;the&nbsp;routingtable</td><td width =10></td><td>"+100*(new Float(outboundNotInRoutingtable).floatValue()/new Float(outbound).floatValue())+"%</td></tr>");
				pw.println("<tr><td>&nbsp;</td></tr>");
			}else
				pw.println("<tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr>");
                        pw.println("</table>\n");
			
			pw.println("</td><td width = 100>&nbsp;</td><td>");
			pw.println("<table>");
			//pw.println("<tr><td colspan = 4 align = 'center'><b>Icon legend</b></td></tr>");
			pw.println("<tr><td colspan = 2><b>Outbound&nbsp;connections&nbsp;legend</b></td><td colspan = 2><b>Inbound&nbsp;connections&nbsp;legend</b></td></tr>");
			pw.println("<tr><td><img SRC='/servlet/images/aqua/arrow_outbound_sleeping.png'></td><td>Idle</td>");
			pw.println("<td><img SRC='/servlet/images/aqua/arrow_inbound_sleeping.png'></td><td>Idle</td></tr>");
			pw.println("<tr><td><img SRC='/servlet/images/aqua/arrow_outbound_transmitting.png'></td><td>Transmitting data</td>");
			pw.println("<td><img SRC='/servlet/images/aqua/arrow_inbound_transmitting.png'></td><td>Transmitting data</td></tr>");
			pw.println("<tr><td><img SRC='/servlet/images/aqua/arrow_outbound_receiving.png'></td><td>Receiving data</td>");
			pw.println("<td><img SRC='/servlet/images/aqua/arrow_inbound_receiving.png'></td><td>Receiving data</td></tr>");
			pw.println("<tr><td><img SRC='/servlet/images/aqua/arrow_outbound_both.png'></td><td>Receiving&nbsp;and&nbsp;transmitting&nbsp;data</td>");
			pw.println("<td><img SRC='/servlet/images/aqua/arrow_inbound_both.png'></td><td>Receiving&nbsp;and&nbsp;transmitting&nbsp;data</td></tr>");
			pw.println("</table></td></tr></table>");
		}
		if(!useOldStyle)
			if(viewLevel==0)
				pw.println("<font size = 1><A HREF = '"+req.getRequestURI()+"?setLevel=1'>[More details]</A></font>");
			else
				pw.println("<font size = 1><A HREF = '"+req.getRequestURI()+"?setLevel=0'>[Less details]</A></font>");
		else
			pw.print("<br><br>");
		
		pw.println("<table border=1 cellspacing = 0>\n");
		
		String sImgClause = "<img src='/servlet/images/aqua/s_ar_"+(iSortingMode<0?"up":"down")+"_olive.gif' height = '9' width = '10'>";
		
		pw.print("<tr>");
		if(!useOldStyle)
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==9?"-9":"9")+"'>"+(Math.abs(iSortingMode)==9?sImgClause:"")+" Type</A></th>");
		if(useOldStyle || viewLevel>0) {
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==1?"-1":"1")+"'>"+(Math.abs(iSortingMode)==1?sImgClause:"")+" Peer address</A></th>");
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==11?"-11":"11")+"'>"+(Math.abs(iSortingMode)==11?sImgClause:"")+" Routing address</A></th>");
		}else
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==11?"-11":"11")+"'>"+(Math.abs(iSortingMode)==11?sImgClause:"")+" Peer</A></th>");
		if(useOldStyle || viewLevel>0)
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==2?"-2":"2")+"'>"+(Math.abs(iSortingMode)==2?sImgClause:"")+" Peer identity</A></th>");
		pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==4?"-4":"4")+"'>"+(Math.abs(iSortingMode)==4?sImgClause:"")+" Queue</A></th>");
		if(useOldStyle)
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==5?"-5":"5")+"'>"+(Math.abs(iSortingMode)==5?sImgClause:"")+" Receiving</A></th>");
		pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==6?"-6":"6")+"'>"+(Math.abs(iSortingMode)==6?sImgClause:"")+" Messages</A></th>");
		
		pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==7?"-7":"7")+"'>"+(Math.abs(iSortingMode)==7?sImgClause:"")+" Idletime</A></th>");
		pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==8?"-8":"8")+"'>"+(Math.abs(iSortingMode)==8?sImgClause:"")+" Lifetime</A></th>");
				
		if(useOldStyle)
			pw.print("<th><A HREF='"+req.getRequestURI()+"?setSorting="+(iSortingMode==9?"-9":"9")+"'>"+(Math.abs(iSortingMode)==9?sImgClause:"")+" Type</A></th>");
		pw.println(buffer.toString());
		pw.println("</table>");
	}


    ////////////////////////////////////////////////////////////
    // Helper functions to enforce hard limits on the maximum 
    // number of concurrent blocked connections we allow to 
    // a single address.
    //
    private Hashtable blockedConnections = new Hashtable();
    private int blockedConnectionCount = 0;

    private final int MAXBLOCKEDCONNECTIONS = 1;

    private final void incHardConnectionLimit(Address addr)
        throws ConnectFailedException {
	boolean logDEBUG = Core.logger.shouldLog(Logger.DEBUG);
        int val = 0;
        synchronized(blockedConnections) {
            blockedConnectionCount++;
            Integer count = (Integer)blockedConnections.get(addr.toString());
            if (count != null) {
                val = count.intValue();
                if (val >= MAXBLOCKEDCONNECTIONS) {
                    
		    if(logDEBUG)
			Core.logger.log(OpenConnectionManager.this,
					" Too many blocked connection, aborting: " 
					+ addr.toString() +
					" " + val,
					Logger.DEBUGGING);
		    
                    // So that the arithmetic works when
                    // dec is called in finally block.
                    blockedConnections.put(addr.toString(), new Integer(val + 1));
                    
                    // Terminal.
                    throw new ConnectFailedException(addr, "Exceeded blocked connection limit: " +
                                                     val + " for " + addr);
                }
            }
            blockedConnections.put(addr.toString(), new Integer(val + 1));
        
        }
	if(logDEBUG) Core.logger.log(OpenConnectionManager.this,
				     " blocked: " + addr.toString() +
				     " " + (val),
				     Logger.DEBUGGING);
        
    }

    private final void decHardConnectionLimit(Address addr) {
        synchronized(blockedConnections) {
            blockedConnectionCount--;
            Integer count = (Integer)blockedConnections.get(addr.toString());
            if (count != null) {
                int val = count.intValue();
                if (val > 0) {
                    blockedConnections.put(addr.toString(), new Integer(val - 1));
                }
                else {
                    blockedConnections.remove(addr.toString());
                }
            }
        }
    }



    ////////////////////////////////////////////////////////////

    private class ConnectionJob implements Runnable {

        private boolean done = false;
        private ConnectionHandler ch = null;
        private CommunicationException e = null;

        private final Core core;
        private final Peer p;

        public ConnectionJob(Core core, Peer p) {
	    if(Core.logger.shouldLog(Logger.DEBUG))
		Core.logger.log(this, "Creating ConnectionJob (core, "+p+"): "+
				this, new Exception("debug"), Logger.DEBUG);
            this.core = core;
            this.p = p;
        }
	
        public void run() {
	    
            long start = System.currentTimeMillis();
            Connection c = null;
            
            boolean connected = false;
            int loops = 5;
            OutputStream crypt = null;
	    boolean logDEBUG = core.logger.shouldLog(Logger.DEBUG);
            do {
                try {
                    LinkManager linkManager = p.getLinkManager();
                    Presentation presentation = p.getPresentation();
		    
                    try {
			if(logDEBUG) core.logger.log(OpenConnectionManager.this,
						     " blocked connections " + 
						     blockedConnectionCount,
						     core.logger.DEBUGGING);
                        // IMPORTANT:
                        // The connect() call below can block for
                        // a long time before failing
                        // (3 minutes on rh7.1, IBM JDK 1.3).
                        // 
                        // Fail immediately if there are too 
                        // many blocked connections for 
                        // the requested address.
                        incHardConnectionLimit(p.getAddress());
                        c = p.getAddress().connect(false);
			// Will be limited but only after enableThrottle() called by CH
			
			// We do not throttle at this stage - 
			// it will be wrapped after negotiation
		    } finally {
                        decHardConnectionLimit(p.getAddress());
                        if (Core.outboundContacts != null) {
                            String countAddr = null;
                            if (c != null) {
                                // Address we connected to.
                                countAddr = c.getPeerAddress().toString();
                            }
                            else {
                                // Address we tried to connect to.
                                countAddr = p.getAddress().toString();
                            }
                            // Keep track of outbound connection attempts.
                            Core.outboundContacts.incTotal(countAddr);
                        }
                    }
		    if(Core.logger.shouldLog(Logger.MINOR))
			Core.logger.log(OpenConnectionManager.this, 
					"Established connection: " + c + "("+
					this + ")", Logger.MINOR);
                    
                    OutputStream raw = c.getOut();
		    if(raw == null) 
			throw new IOException("Connection already closed");
                    int i = linkManager.designatorNum();
                    raw.write((i >> 8) & 0xff);
                    raw.write(i & 0xff);
		    
		    if(logDEBUG) 
			Core.logger.log(this, "Written, creating link: "+c+"("+
					this + ")", Logger.DEBUG);
                    //raw.flush(); don't want to flush here
                    Link l = linkManager.createOutgoing(core.privateKey,
                                                        core.identity, 
                                                        p.getIdentity(), c);
		    if(logDEBUG)
			core.logger.log(OpenConnectionManager.this,
					"Connection between: " 
					+ l.getMyAddress() + 
					" and " + l.getPeerAddress()+
					" ("+this+","+c+")",
					core.logger.DEBUG);
                    
                    /* OutputStream */ crypt = l.getOutputStream();
                    int j = presentation.designatorNum();
		    if(logDEBUG) 
			core.logger.log(this, "Got OStream, writing control "+
					c, Logger.DEBUG);
                    crypt.write((j >> 8) & 0xff);
                    crypt.write(j & 0xff);
		    if(logDEBUG)
			core.logger.log(this, "Written control bytes, flushing "+
					c, Logger.DEBUG);
		    l.getOutputStream().flush();
                    //crypt.flush(); or here, we might as well wait
                    c.enableThrottle();
                    ch = new ConnectionHandler(OpenConnectionManager.this,
                                               presentation, l, 
                                               core.ticker(),
                                               3, core.maxPadding, true);
		    if(logDEBUG) Core.logger.log(this, "Got ConnectionHandler: "+
						 this+"->"+ch, Logger.DEBUG);
                    //runCh = true;
                    //ch.start();
		    ch.configWSL(tcpConnection.getWSL());
		    if(logDEBUG) Core.logger.log(this, "configged WSL for "+
						 ch+" ("+this+")", Logger.DEBUG);
                    if (!core.hasInterfaceFor(ch.transport())) {
                        // if we don't have an interface for this transport, we
                        // will ask this connection to persist.
                        Message m = ch.presentationType().getSustainMessage();
                        if (m != null)
                            ch.sendMessage(m);
                    }
		    
		    long now = System.currentTimeMillis();
		    long connectingTime = now - start;
		    if(logDEBUG || connectingTime > 500)
			Core.logger.log(this, "connectingTime: "+connectingTime+
					" at "+now+" ("+this+")", 
					connectingTime > 500 ? 
					Core.logger.MINOR : Core.logger.DEBUG);
                    core.diagnostics.occurrenceContinuous("connectingTime", 
							  connectingTime);
                    
                    connected = true;
                    
                } catch (java.net.SocketException e) {
			//just log it
		    if(Core.logger.shouldLog(Logger.MINOR))
			Core.logger.log(this, "socket exception happened - "+
					"probably NIOOS got closed before "+
					"finishing: "+e,e,Logger.MINOR);
		    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        e.getMessage(),
                                                        false);
		} catch (IOException e) {
                    // Only code path that causes us to loop.
                    // All the other exceptions are terminal.
                    // I don't understand the intent of the looping.
                    // It seems like a very bad idea to me 
                    // i.e. DOSing on transport level connection failure
                    // is exactly the wrong thing to do. 
                    //
                    // However It's not an issue since this code never
                    // appears to be executed.
                    // --gj
                    e.printStackTrace();
                    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        e.getMessage(),
                                                        false);
		    core.logger.log(OpenConnectionManager.this, 
				    "[LOOPING (A)!]Transport level connect "+
				    "failed to: "+ p.getAddress() + " -- " +
				    e+" ("+this+","+c+","+ch+")", e, Logger.ERROR);
		    //this.e, Logger.DEBUG);
                } catch (SendFailedException e) {
                    this.e = new ConnectFailedException(e);
                    e.setIdentity(p.getIdentity());
		    if(logDEBUG)
			core.logger.log(OpenConnectionManager.this, 
					"Transport level connect failed to: "
					+ p.getAddress() + " -- " + e+" ("+
					this+","+ch+")", Logger.DEBUG); 
		    //this.e, Logger.DEBUG);
                } catch (ConnectFailedException e) {
                    this.e = e;
                    e.setIdentity(p.getIdentity());
		    if(logDEBUG)
			core.logger.log(OpenConnectionManager.this, 
					"Transport level connect failed to: "
					+ p.getAddress() + " -- " + e+" ("+
					this+","+ch+")", Logger.DEBUG);
		    //e, Logger.DEBUG);
                    // I'll attempt to fall back on an open connection.
                    // I can't decide if this is a nice hack or an ugly hack..
                    //ch = findBestConnection(p.getIdentity());
                    //if (ch == null) {
                    //    this.e = e;
                    //} else {
                    //    try {
                    //        for (int j = 0 ; j < 5 && !ch.sending();
                    //             j++) {
                    //            Core.logger.log(this, 
                    //                            "Waiting for CH. Sending:" +
                    //                            ch.sending() + " Count: " +
                    //                            ch.sendingCount(), 
                    //                            Logger.DEBUG);
                    //                            
                    //            ch.sendMessage(null);
                    //        }
                    //    } catch (SendFailedException sfe) {
                    //        this.e = sfe;
                    //    }
                    //}
                } catch (NegotiationFailedException e) {
                    this.e = e;
		    if(core.logger.shouldLog(Logger.MINOR))
			core.logger.log(OpenConnectionManager.this,
					"Negotiation failed with: "
					+ p.getAddress() + " -- " + e+" ("+
					this+","+ch+")", Logger.MINOR);
		    //e, Logger.MINOR);
                } catch (AuthenticationFailedException e) {
                    this.e = e;
		    if(core.logger.shouldLog(Logger.MINOR))
			core.logger.log(OpenConnectionManager.this,
					"Authentication failed with: "
					+ p.getAddress() + " -- " + e+" ("+
					this+","+ch+")", Logger.MINOR);
		    //e, Logger.MINOR);
		    //} catch (IOException e) {
		    //    core.logger.log(OpenConnectionManager.this,
		    //                    "I/O error during negotiation with: "
		    //                    + p.getAddress(),
		    //                    e, Logger.MINOR);
		    //    this.e = e;
                } catch (Throwable e) {
                    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        e.getMessage(),
                                                        true);
                    core.logger.log(OpenConnectionManager.this,
                                    "Unknown exception "+e+
				    " while connecting to: "+ p.getAddress()+
				    " ("+this+","+ch+")", e, Logger.ERROR);
		}
            } while (!connected && !e.isTerminal() && --loops > 0);
	    
            if (connected) {
		if(logDEBUG) 
		    core.logger.log(this, "Connected: "+p.getAddress()+" "+this+
				    " : "+ch, Logger.DEBUG);
                try {
		    ch.configRSL(tcpConnection.getRSL());
		    ch.registerOCM(); // AFTER flushOut() and configWSL
		    if(logDEBUG) core.logger.log(this, "Flushed "+this+","+ch, 
						 Logger.DEBUG);
		    
		    java.net.Socket sock;
		    try {
			sock = ((freenet.transport.tcpConnection)c).getSocket();
			if(sock == null) throw new IOException("Null socket");
		    } catch (IOException e) {
			this.e = new ConnectFailedException(p.getAddress(),
							    p.getIdentity(),
							    e.getMessage(),
							    false);
			if(logDEBUG) 
			    Core.logger.log(this, "Could not get socket! ("+this+
					    ","+ch+")", e, Logger.DEBUG);
			synchronized (this) {
			    done = true;
			    this.notifyAll();
			}
			
			return;
		    }
		    try {
			java.nio.channels.SocketChannel sc = sock.getChannel();
			if(logDEBUG) Core.logger.log(this, "tcpConnection", Logger.DEBUG);
			sc.configureBlocking(false);
		    } catch (IOException e) {
			Core.logger.log(this, "Cannot configure nonblocking mode on SocketChannel! ("+this+","+ch+")", Logger.ERROR);
			this.e = new ConnectFailedException(p.getAddress(),
							    p.getIdentity(),
							    e.getMessage(),
							    false);
			core.logger.log(OpenConnectionManager.this, 
					"[LOOPING (B)!]Transport level connect "+
					"failed to: "+ p.getAddress() + 
					" -- " + e+" ("+this+","+c+","+ch+")", 
					e, Logger.ERROR);
			//this.e, Logger.DEBUG);
			synchronized (this) {
			    done = true;
			    this.notifyAll();
			}
			return;
		    }
		    NIOInputStream niois = (NIOInputStream) 
			((tcpConnection)c).getUnderlyingIn();
		    niois.setNextReader(ch);
		    tcpConnection.getRSL().unregister(niois);
		    while(niois.isRegistered() && 
			  (!niois.alreadyClosedLink())) {
			synchronized(niois.unregLock) {
			    if(niois.isRegistered()) break;
			    try{
				niois.unregLock.wait(200);
			    }catch(InterruptedException e) {
				Core.logger.log(this,"couldn't complete unregistration of NIOIS",Logger.ERROR);
				throw new IOException("couldn't complete unregistration of NIOIS");
			    }
			}
		    }
		    if(niois.alreadyClosedLink()) {
			Core.logger.log(this, "Already closed link, not registering: "+
					this, Logger.MINOR);
			c.close();
			ch.terminate();
			throw new IOException("Already closed link");
		    }
		    // is now unregistered, it will not be checked until we are
		    // registered
		    tcpConnection.getRSL().register(sock, ch);
		    tcpConnection.getRSL().scheduleMaintenance(ch);
		    if(logDEBUG) Core.logger.log(this, "Registered "+this+":"+ch,
						 Logger.DEBUG);
                    //ch.run();
		} catch (IOException e) {
		    this.e = new ConnectFailedException(p.getAddress(),
							p.getIdentity(),
							e.getMessage(),
							false);
		    if(logDEBUG) Core.logger.log(this, "Could not get socket! ("+
						 this+","+ch+") - "+e, e, Logger.DEBUG);
		    synchronized (this) {
			done = true;
			this.notifyAll();
		    }
		    
		    return;
                } catch (RuntimeException e) {
		    // FIXME: is there a need for notification here?
                    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        e.getMessage(),
                                                        true);
                    c.close();
                    Core.logger.log(this,
				    "Unhandled throwable while handling "+
				    "connection ("+this+","+ch+")", e, 
				    Logger.ERROR);
		    synchronized (this) {
			done = true;
			this.notifyAll();
		    }
                    throw e;
                } catch (Error e) {
		    // FIXME: is there a need for notification here?
                    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        e.getMessage(),
                                                        true);
                    Core.logger.log(this,
				    "Unhandled throwable while handling "+
				    "connection ("+this+","+ch+")", e, 
				    Logger.ERROR);
		    synchronized (this) {
			done = true;
			this.notifyAll();
		    }
                    throw e;
                }
            } else if (ch != null) {
		if(logDEBUG)
		    Core.logger.log(this, "Failed connection ("+this+
				    "), terminating "+ch, Logger.DEBUG);
                ch.terminate();
		if(e == null) {
                    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        "null ch",
                                                        true);
		}
	    } else if (c != null) {
		if(logDEBUG)
		    Core.logger.log(this, "Failed connection ("+this+
				    "), no ch, closing", Logger.DEBUG);
		if(e == null) {
                    this.e = new ConnectFailedException(p.getAddress(),
                                                        p.getIdentity(),
                                                        "null c",
                                                        true);
		}
                c.close();
	    }
	    // One way or another...
	    synchronized (this) {
		done = true;
		this.notifyAll();
	    }
	    if(logDEBUG) Core.logger.log(this, "Notified "+this+":"+ch,
					 Logger.DEBUG);
        }
    }
}




