-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


return function (values)
   local meta, self, oldindex, oldnewindex

   self = frames.transform {
      button = switches.button {
	 nut = options.toon and toon.cel {
	    color = math.scale({1, 1, 1}, 0.3),
	    thickness = 2,
	    
	    mesh = resources.static "aviation/meshes/nut.lc" {}
	 } or shading.cook {
	    diffuse = math.scale ({1.5, 0.9, 1}, 0.04),
	    specular = math.scale ({0.12, 0.17, 0.19}, 0.7), 
	    parameter = {1.3, 0.15},
	    
	    mesh = resources.static "aviation/meshes/nut.lc" {},
	 },
	 
	 bulb = options.toon and toon.cel {
	    color = math.scale ({0.9, 0.2, 0.2}, 0.3),
	    thickness = 2,
	    
	    mesh = resources.static "aviation/meshes/bulb.lc" {}
	 } or shading.phong {
	    diffuse = math.scale ({0.9, 0.2, 0.2}, 0.3),
	    specular = math.scale ({1, 1, 1}, -0.1),
	    parameter = 1,
	    
	    mesh = resources.static "aviation/meshes/bulb.lc" {},
	 },
	 
	 highlight = widgets.highlight {
	    mesh = resources.static "aviation/meshes/nut.lc" {},

	    color = {0.7, 0.6, 0.1},
	    width = 5,
	    thickness = 1.5,
	    radius = 0.03,
	    angle = 60,
	    
	    text = string.format([[<span font="Sans 10" color="Khaki">Indicator</span>]])
	 },

	 selected = frames.transform {
	    link = function (self)
		      self.parent.highlight.speed = 8
		   end,

	    unlink = function (self)
			self.parent.highlight.speed = -4
		     end,
	 },
      },
   }

   meta = getmetatable (self)
   meta.label = "Light"
   meta.flick = nil

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "label" then
			return meta.label
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "label" then
	 meta.label = value

	 self.button.highlight.text = string.format([[<span font="Sans 10" color="Khaki">%s</span>]], value)
      elseif key == "on" then
	 oldnewindex(self, key, value)

	 if self.on then
	    self.button.bulb.color = options.toon and
	       math.scale ({0.9, 0.2, 0.2}, 1.5)
	    self.button.bulb.diffuse = not options.toon and
	       math.scale ({0.9, 0.2, 0.2}, 1.5)
	 else
	    self.button.bulb.color = options.toon and
	       math.scale ({0.9, 0.2, 0.2}, 0.3)
	    self.button.bulb.diffuse = not options.toon and
	       math.scale ({0.9, 0.2, 0.2}, 0.3)
	 end
      else
	 oldnewindex(self, key, value)
      end
   end

   meta.__tostring = function(self)
			 return "Indicator"
		      end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end
