-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

aviation.nodes.screen = widgets.screen {
   position = {0, 0, 0.003},
   align = {0, 1},
   size = {0.15, 0.07},
}

aviation.nodes.autopilot = frames.node {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   link = function (self)
	     self.target = self.ancestry[2].position[3]
	  end,

   step = function (self)
	     self.elevators = 0.005 * (self.ancestry[2].velocity[3] + 0) + 0.001 * (self.ancestry[2].position[3] - self.target)
	     self.ailerons = 0.0
	  end
}
 
aviation.nodes.stallindicator = switches.toggle {
   on = resources.loop "aviation/waves/buzzer.lc" {
      reference = 1 / 0,
      gain = 0.3,
   },

   prepare = function (self)
		local uvw, alpha

		-- Calculate the angle of attack.

		uvw = transforms.tonode(self.ancestry[4],
					self.ancestry[4].velocity)
		alpha = math.abs(math.atan2 (uvw[3], uvw[1])) + 1e-3

		if alpha < units.radians (0.18) then
		   -- Well below the critical angle, switch off.

		   self.timer = nil
		   self.state = false
		elseif alpha > units.radians (0.23) then
		   -- Stalling, keep on.

		   self.timer = nil
		   self.state = true
		else
		   -- About to stall, start flashing.

		   if not self.timer then
		      self.timer = frames.timer {
			 tick = function (self)
				   self.parent.state = not self.parent.state
				end
		      }
		   end

		   self.timer.period = (units.radians (0.24) - alpha) /
		   units.radians (0.06)
	     end
	     
	     -- Turn light on and off.

	     self.parent.on = self.state
	  end,
}

aviation.nodes.yawdamper = frames.node {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   step = function (self)
      local pqr, delta_r

      -- Calculate the spin in the local frame.

      pqr = transforms.tonode(self.ancestry[2], self.ancestry[2].spin)

      -- Caclulate the rudder input using a PD controller.

      delta_r = -0.5 * pqr[3]
      
      -- print (delta_r, beta, pqr[3]);

      self.rudder = math.clamp(delta_r, 
			       units.degrees(-15),
			       units.degrees(15))
   end
}

aviation.nodes.aileroncontrol = frames.node {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   begin = function (self)
	      self.ailerons = math.clamp(self.parent.ailerons,
					 units.degrees (-20),
					 units.degrees (20))
	   end
}

aviation.nodes.elevatorcontrol = frames.node {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   begin = function (self)
	      self.elevators = math.clamp(self.parent.elevators,
					  units.degrees (-23),
					  units.degrees (28))
	   end
}

aviation.nodes.ruddercontrol = frames.node {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   begin = function (self)
	      self.rudder = math.clamp(self.parent.rudder,
				       units.degrees (-16),
				       units.degrees (16))

	   end
}

aviation.nodes.throttlecontrol = frames.node {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   begin = function (self)
	      self.throttle = self.parent.throttle
	   end
}

aviation.nodes.rubberband = frames.cursor {
   ailerons = 0,
   elevators = 0,
   rudder = 0,
   throttle = 0,

   anchor = shapes.points {
      color = {0.11, 0.26, 0.007},
      opacity = 0.8,
      width = 6,
      
      [1] = {0, 0},
   },
	 
   ailerator = shapes.lines {
      color = {0.4926, 1.0000, 0.0288},
      opacity = 0.8,
      width = 2,
      
      [1] = {0, 0},
      [2] = {0, 0},
   },
	 
   blue = shapes.lines {
      color = {0.4926, 0.0288, 1.0000},
      opacity = 0.8,
      width = 2,
      
      [1] = {0, 0},
      [2] = {0, 0},
   },

   banchor = shapes.points {
      color = {0.11, 0.007, 0.26},
      opacity = 0.8,
      width = 6,
      
      [1] = {0, 0},
   },
	 
   cursor = shapes.points {
      color = {0.11, 0.26, 0.007},
      opacity = 0.8,
      width = 4,

      [1] = {0, 0},
   },

   begin = function (self)
	      local endpoint, foo

	      endpoint = {-self.parent.ailerons / aviation.sensitivity[1],
			  self.parent.elevators / aviation.sensitivity[2]}

	      foo = {self.parent.rudder / aviation.sensitivity[3], 0}

	      self.anchor[1] = endpoint
	      self.ailerator[1] = endpoint

	      self.blue[1] = foo
	      self.banchor[1] = foo
	   end
}
