//  Copyright (C) 2010, 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_DOCUMENT_DIALOG_H
#define TAPIOCA_DOCUMENT_DIALOG_H

#include <gtkmm.h>
#include <gconfmm.h>
#include "document.h"
#include "item-tagging-widget.h"
using namespace Tapioca;

class DocumentDialog: public Gtk::Dialog
{
 public:
        
     enum Tab { 
       GENERAL = 0, GEOGRAPHIC_INFORMATION = 1, TAGS = 2,
     };
    static DocumentDialog *create(Tapioca::Document *g, 
                                  const Tapioca::Document *original,
                                  std::list<std::string> all_tags,
                                  bool readonly = false);
    
    DocumentDialog(BaseObjectType* baseObject, 
                   const Glib::RefPtr<Gtk::Builder>& xml);

    virtual ~DocumentDialog();

    static Tab last_tab_opened;
    static Gtk::Allocation last_window_size;
    sigc::signal<void, Tapioca::Document*>view_document;
    sigc::signal<void, std::list<std::string> > tags_changed;
 private:
    Tapioca::Document *document;
    const Tapioca::Document *original;
    bool readonly;
    Gtk::Notebook *notebook;
    Gtk::Entry *title_entry;
    Gtk::TextView *description_textview;
    Gtk::Image *thumbnail_image;
    Gtk::SpinButton *lat_spinbutton;
    Gtk::SpinButton *lon_spinbutton;
    Gtk::VBox *item_tagging_widget_container;
    Tapioca::ItemTaggingWidget *item_tagging_widget;
    Gtk::Label *title_label;
    Gtk::Label *description_label;
    Gtk::Label *latitude_label;
    Gtk::Label *longitude_label;
    sigc::connection page_switcher;
    Gtk::Button *view_document_button;

    //helpers
    void set_tab(Tab tab) {notebook->set_current_page(int(tab));};
    Tab get_tab() const {return Tab(notebook->get_current_page());};

    //callbacks
    void on_title_changed();
    void on_description_changed();
    void on_lat_changed();
    void on_lon_changed();
    void on_dialog_loaded(Tapioca::Document *g, 
                          const Tapioca::Document *original, 
                          std::list<std::string> all_tags,
                          bool readonly = false);
    void on_response_received(int response);
    void on_notebook_page_switched(guint page_num);
    void on_view_document_clicked();

};

#endif // TAPIOCA_DOCUMENT_DIALOG_H
