//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <gtkmm.h>
#include <config.h>

#include "connect-dialog.h"
#include "main.h"
#include "ucompose.hpp"
#include "profile.h"

ConnectDialog* ConnectDialog::create(Tapioca::Profile *p, bool modify_username)
{
  Glib::RefPtr<Gtk::Builder> xml
    = Gtk::Builder::create_from_file(Main::get_glade_path()
                                     + "/connect-dialog.gtk");
  ConnectDialog *dialog;
  xml->get_widget_derived("dialog", dialog);
  dialog->on_dialog_loaded(p, modify_username);
  return dialog;
}

ConnectDialog::ConnectDialog(BaseObjectType* baseObject, 
                             const Glib::RefPtr<Gtk::Builder>& xml)
 : Gtk::Dialog(baseObject)
{

  set_icon_from_file(Main::get_data_path() + "/tapioca.png");

  xml->get_widget("username_entry", username_entry);
  xml->get_widget("password_entry", password_entry);
  xml->get_widget("accept_button", accept_button);

  username_entry->signal_changed().connect
    (sigc::mem_fun(this, &ConnectDialog::on_username_changed));
  password_entry->signal_changed().connect
    (sigc::mem_fun(this, &ConnectDialog::on_password_changed));
  signal_response().connect
    (sigc::mem_fun(this, &ConnectDialog::on_response_received));
}

void ConnectDialog::on_dialog_loaded(Tapioca::Profile *p, bool modify_username)
{
  profile = p;
  username_locked = !modify_username;
  Glib::RefPtr<Gnome::Conf::Client> conf_client;
  conf_client = Gnome::Conf::Client::get_default_client();
  username_entry->set_text
    (conf_client->get_string
     ("/apps/" PACKAGE_NAME "/general/previous_username"));
  if (username_entry->get_text() == "")
    username_entry->set_text(profile->get_username());
  password_entry->set_text(profile->get_password());
  if (username_entry->get_text() != "")
    password_entry->grab_focus();
  else
    username_entry->grab_focus();
  update_buttons();
  if (username_locked == true && username_entry->get_text() != "")
    username_entry->set_sensitive(false);
}

ConnectDialog::~ConnectDialog()
{
}

void ConnectDialog::on_response_received(int response)
{
  if (response == Gtk::RESPONSE_ACCEPT)
    {
      Glib::RefPtr<Gnome::Conf::Client> conf_client;
      conf_client = Gnome::Conf::Client::get_default_client();
      conf_client->set("/apps/" PACKAGE_NAME "/general/previous_username", 
                       username_entry->get_text());
    }
}

void ConnectDialog::on_username_changed()
{
  if (profile)
    {
      profile->set_username(username_entry->get_text());
      update_buttons();
    }
}

void ConnectDialog::on_password_changed()
{
  if (profile)
    {
      profile->set_password(password_entry->get_text());
      update_buttons();
    }
}

void ConnectDialog::update_buttons()
{
  accept_button->set_sensitive (username_entry->get_text() != "" && password_entry->get_text() != "");
}
