// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_CHANGED_DOCUMENT_H
#define TAPIOCA_CHANGED_DOCUMENT_H

#include <gtkmm.h>
#include <string>

#include "document.h"

namespace Tapioca 
{
class ChangedDocument
{
    public:

	//! Constructor.
        ChangedDocument(const Tapioca::Document orig, const Tapioca::Document dest);

	//! Destructor.
        virtual ~ChangedDocument();

        Glib::ustring get_change_description() const;
        static Glib::ustring get_change_description_for_items(Tapioca::Item first, Tapioca::Item second, Glib::ustring extra = "");

        Tapioca::Document first;
        Tapioca::Document second;

        //operators
        bool operator==(const ChangedDocument &other)
          {
            return first == other.first && second == other.second;
          }

        bool reverted() {return first == second;}
    protected:

    private:
};
}

#endif // TAPIOCA_CHANGED_DOCUMENT_H

