// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_GALLERY_LIST_H
#define TAPIOCA_GALLERY_LIST_H

#include <gtkmm.h>
#include <string>
#include <list>

#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/list.hpp>
#include "gallery.h"
namespace Tapioca
{
class Gallery;
class Document;
class ChangedGallery;
class ChangedDocument;
class GalleryList
{
    public:

	//! Copy constructor.
        GalleryList(const GalleryList& gallery_list);

	//! Create an empty gallery list.
	GalleryList();

	//! Destructor.
        virtual ~GalleryList();
        
        typedef std::list<Gallery*>::iterator iterator;
        typedef std::list<Gallery*>::const_iterator const_iterator;

        void add(const GalleryList *g);
        std::list<ChangedGallery> get_changed_galleries(const GalleryList *g) const;
        std::list<ChangedDocument> get_changed_documents(const GalleryList *g) const;
        std::list<ChangedGallery> get_removed_galleries(const GalleryList *g) const;
        std::list<ChangedDocument> get_removed_documents(const GalleryList *g) const;
        Gallery* find_by_id(std::string id) const;
        Document* find_doc_by_id(const std::string id) const;
        
        size_t size() const {return _galleries.size();}
        Gallery* back() {return _galleries.back();}
        void remove(Gallery *gallery) {_galleries.remove(gallery);}
        void push_back(Gallery *gallery) {_galleries.push_back(gallery);}

        bool is_same(const GalleryList &g) const;
        void update_thumbnails();
        void find_deleted_documents(std::list<Document*> &removed);
        void remove_all_galleries();
        size_t count_documents() const;
        void export_html_pages(std::string username, std::string dir) const;

        //std::list<Gallery*>& get_galleries() {return _galleries;}
        const std::list<Gallery*>& get_galleries()const {return _galleries;}
    private:

        friend class boost::serialization::access;
                             
        template<class Archive>
          void serialize(Archive & ar, const unsigned int version)
            {
              //ar & static_cast<std::list<Gallery*>&>(*this);
              ar & _galleries;
            }
        std::list<Gallery*> _galleries;

};
}

#endif // TAPIOCA_GALLERY_LIST_H

