// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "changed-document.h"

using namespace Tapioca;

ChangedDocument::ChangedDocument(const Document orig, const Document dest)
{
  first = orig;
  second = dest;
}

ChangedDocument::~ChangedDocument()
{
}

Glib::ustring ChangedDocument::get_change_description() const
{
  return ChangedDocument::get_change_description_for_items(first, second);
}

Glib::ustring ChangedDocument::get_change_description_for_items(Item first, Item second, Glib::ustring extra) 
{
  std::list<Glib::ustring> modified;
  Glib::ustring desc = "";

  if (first.get_title() != second.get_title())
    modified.push_back("title");
  if (first.get_description() != second.get_description())
    modified.push_back("description");
  if (first.get_latitude() != second.get_latitude())
    modified.push_back("latitude");
  if (first.get_longitude() != second.get_longitude())
    modified.push_back("longitude");
  if (first.get_order() != second.get_order())
    modified.push_back("priority");
  if (first.get_tags() != second.get_tags())
    modified.push_back("tags");
  if (extra != "")
    modified.push_back(extra);
  if (modified.size() == 0)
    {
      desc = "No modifications.";
      return desc;
    }

  desc = "Modified ";
  for (std::list<Glib::ustring>::iterator i = modified.begin(); 
       i != modified.end(); i++)
    {
      if (i == --modified.end() && modified.size() > 1)
        desc += " and ";
      else if (i != modified.begin())
        desc += ", ";
      desc += *i;
    }
  desc += ".";

  return desc;
}
