//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef ITEM_TAGGING_WIDGET_H
#define ITEM_TAGGING_WIDGET_H

#include <gtkmm.h>
#include <list>
#include <string>
#include "item.h"
using namespace Tapioca;
namespace Tapioca 
{
class ItemTaggingWidget
{
 public:
    ItemTaggingWidget();
    ~ItemTaggingWidget();
    Gtk::Widget *get_widget() {return contents;}

    void fill_tags(std::list<std::string> tags);
    std::list<std::string> get_tags();
 protected:

 private:
    std::list<std::string> tags;
    Gtk::VBox *contents;
    Gtk::Label *tags_count_label;
    Gtk::TreeView *treeview;
    Gtk::Button *add_button;
    Gtk::Button *remove_button;
    //for the treeview
    class TagsColumns: public Gtk::TreeModelColumnRecord {
  public:
      TagsColumns()
	{add(name);}
      Gtk::TreeModelColumn<Glib::ustring> name;
    };
    const TagsColumns tags_columns;
    Glib::RefPtr<Gtk::ListStore> tags_list;
    Gtk::CellRendererText name_renderer;
    Gtk::TreeViewColumn name_column;
    void cell_data_tag(Gtk::CellRenderer *renderer, const Gtk::TreeIter &i);

    //callbacks
    void on_tag_selected();
    void on_add_clicked();
    void on_remove_clicked();
    void on_tag_edited(const Glib::ustring &path, const Glib::ustring &new_text);
    void on_cancel_tag_edit();

  //helpers
    void fill_tags();
    void add_tag_row(std::string tag);
    std::string get_selected_tag();
    bool has_tag(std::string tag) const;
    void add_tag(std::string tag);
    void remove_tag(std::string tag);
    void update_tag(std::string oldvalue, std::string newvalue);
    bool validate_tag(std::string tag, bool show_error = true);


    static std::string default_tag_name;
    bool inhibit;
};
}

#endif // TAPIOCA_ITEM_TAGGING_WIDGET_H
