//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_WINDOW_H
#define TAPIOCA_WINDOW_H

#include <memory>
#include <gtkmm.h>
#include "gallery.h"
#include "session.h"

#define TAPIOCA_EXT ".tao"
class TapiocaWindow
{
 public:
    TapiocaWindow();

    Gtk::Window *get_window() {return window.get();};
    bool run();
    void hide();
    
 private:
    std::auto_ptr<Gtk::Window> window;

    //for the treeview
    class GalleriesColumns: public Gtk::TreeModelColumnRecord {
  public:
      GalleriesColumns()
	{add(name); add(data);}
      Gtk::TreeModelColumn<Glib::ustring> name;
      Gtk::TreeModelColumn<Tapioca::Gallery*> data;
    };
    const GalleriesColumns galleries_columns;
    Glib::RefPtr<Gtk::ListStore> galleries_list;
    
    //for the iconview
    class DocumentsColumns: public Gtk::TreeModelColumnRecord {
  public:
      DocumentsColumns() {add(name); add(image); add(data);}
      Gtk::TreeModelColumn<Glib::ustring> name;
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Tapioca::Document*> data;
    };
    const DocumentsColumns documents_columns;
    Glib::RefPtr<Gtk::ListStore> documents_list;

    //widgets
    Gtk::HBox *contents;
    Gtk::TreeView *treeview;
    Gtk::IconView *iconview;
    Gtk::MenuItem *connect_menuitem;
    Gtk::MenuItem *open_offline_menuitem;
    Gtk::MenuItem *save_offline_menuitem;
    Gtk::MenuItem *save_offline_as_menuitem;
    Gtk::MenuItem *save_changes_menuitem;
    Gtk::MenuItem *export_menuitem;
    Gtk::MenuItem *exit_menuitem;
    Gtk::MenuItem *preferences_menuitem;
    Gtk::MenuItem *image_properties_menuitem;
    Gtk::MenuItem *gallery_properties_menuitem;
    Gtk::MenuItem *about_menuitem;
    Gtk::Label *gallery_label;

    Gtk::Menu treeview_context_menu;
    Gtk::Menu iconview_context_menu;

    //callbacks
    void on_connect_clicked();
    void on_open_offline_changes_clicked();
    void on_save_offline_changes_clicked();
    void on_save_offline_changes_as_clicked();
    void on_save_changes_to_atpic_clicked();
    void on_export_clicked();
    void on_exit_clicked();

    void on_preferences_clicked();
    void on_image_properties_clicked();
    void on_gallery_properties_clicked();

    void on_about_clicked();

    void on_gallery_selected();
    void on_document_selected();
    void on_gallery_activated(const Gtk::TreeModel::Path& path,
                              Gtk::TreeViewColumn *col);
    void on_document_activated(const Gtk::TreeModel::Path& path);
    void on_treeview_clicked(GdkEventButton* event);
    void on_iconview_clicked(GdkEventButton* event);

    void on_add_gallery_clicked();
    void on_remove_gallery_clicked();
    void on_add_document_clicked();
    void on_remove_document_clicked();
    void on_iconview_reordered(const Glib::RefPtr<Gdk::DragContext>&context);
    void on_document_drag_data_get(const Glib::RefPtr<Gdk::DragContext> &drag_context, Gtk::SelectionData &data, guint info, guint time);
    void on_galleries_drop_drag_data_received(const Glib::RefPtr<Gdk::DragContext> &context, int x, int y, const Gtk::SelectionData& selection_data, guint c, guint time);
    void on_documents_drop_drag_data_received(const Glib::RefPtr<Gdk::DragContext> &context, int x, int y, const Gtk::SelectionData& selection_data, guint c, guint time);

    // helpers
    Tapioca::Gallery* get_selected_gallery();
    Tapioca::Document* get_selected_document();
    void update_menuitems();
    void fill_in_documents();
    void add_document(Tapioca::Document *document);
    void fill_in_galleries();
    void add_gallery(Tapioca::Gallery *gallery);
    void update_selected_gallery_name();
    void update_selected_document_name();
    void save_session();
    void load_session();
    void remove_deleted_documents();


    //DATA
    std::string current_save_filename;
    Tapioca::Session *session;
};

#endif // TAPIOCA_WINDOW_H
