// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_SESSION_H
#define TAPIOCA_SESSION_H

#include <gtkmm.h>
#include <string>
#include <list>

#include "profile.h"
#include "gallerylist.h"

#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/list.hpp>

namespace Tapioca
{
class Session: public GalleryList
{
    public:

	//! Copy constructor.
        Session(const Session& profile);

	//! Create an empty profile.
	Session();

	//! Destructor.
        virtual ~Session();

        // Set Methods
        
        void set_profile(Profile *p) {profile = p;}

        //Get Methods

        Profile* get_profile() const {return profile;}

        static Session* create(Profile *profile);
    protected:

    private:
        Profile *profile;

        friend class boost::serialization::access;
                             
        template<class Archive>
          void serialize(Archive & ar, const unsigned int version)
            {
              ar & profile;
              ar & static_cast<GalleryList&>(*this);
            }
};
}

#endif // TAPIOCA_SESSION_H

