// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "gallerylist.h"
#include "changed-gallery.h"
#include "changed-document.h"
#include "gallery.h"

using namespace Tapioca;

GalleryList::GalleryList(const GalleryList& g)
{
  for (GalleryList::const_iterator it = g.begin(); it != g.end(); it++)
    push_back(new Gallery(*(*it)));
}

Gallery* GalleryList::find_by_id(const std::string id) const
{
  for (GalleryList::const_iterator it = begin(); it != end(); it++)
    {
      if ((*it)->get_id() == id)
        return (*it);
    }
  return NULL;
}

Document * GalleryList::find_doc_by_id(const std::string id) const
{
  for (GalleryList::const_iterator it = begin(); it != end(); it++)
    {
      for (Gallery::const_iterator git = (*it)->begin(); git != (*it)->end(); 
           git++)
        {
          if ((*git)->get_id() == id)
            return (*git);
        }
    }
  return NULL;
}

void GalleryList::add(const GalleryList *g)
{
  if (g)
    {
      for (GalleryList::const_iterator it = g->begin(); it != g->end(); it++)
        push_back(new Gallery(*(*it)));
    }
}

std::list<ChangedGallery> GalleryList::get_changed_galleries(const GalleryList *g) const
{
  std::list<ChangedGallery> difflist;
  //which one of these is different from those?
  for (GalleryList::const_iterator it = begin(); it != end(); it++)
    {
      //does this id appear in the given list?
      Gallery *gallery = g->find_by_id((*it)->get_id());
      if (gallery != NULL)
        {
          if (*gallery == *(*it))
            ;
          else
            {
              ChangedGallery changed_gallery(*(*it), *gallery);
              difflist.push_back(changed_gallery);
            }
        }
    }
  return difflist;
}

std::list<ChangedGallery> GalleryList::get_removed_galleries(GalleryList *g) const
{
  std::list<ChangedGallery> difflist;
  for (GalleryList::const_iterator it = begin(); it != end(); it++)
    {
      Gallery *gallery = g->find_by_id((*it)->get_id());
      if (gallery == NULL)
        {
          ChangedGallery changed_gallery(*(*it), Gallery());
          difflist.push_back(changed_gallery);
        }
    }
  return difflist;
}


void GalleryList::show(Gallery *gallery)
{
  printf("showing gallery:\n");
  printf("id: %s\n", gallery->get_id().c_str());
  printf("lat: %lf\t long: %lf\n", gallery->get_latitude(), gallery->get_longitude());
  printf("title: %s\n", gallery->get_title().c_str());
  printf("description: %s\n", gallery->get_description().c_str());
  printf("doc thumb id: %s\n", gallery->get_thumbnail_id().c_str());
  printf("order: %s\n", gallery->get_order().c_str());
  printf("tags:\n");
  std::list<std::string> tags = gallery->get_tags();
  for (std::list<std::string>::iterator it = tags.begin(); it != tags.end();
       it++)
    {
      printf("\t'%s'\n", (*it).c_str());
    }
}

std::list<ChangedDocument> GalleryList::get_changed_documents(const GalleryList *g) const
{
  std::list<ChangedDocument> difflist;
  for (GalleryList::const_iterator it = begin(); it != end(); it++)
    {
      for (Gallery::const_iterator git = (*it)->begin(); git != (*it)->end(); 
           git++)
        {
          Document *document = g->find_doc_by_id((*git)->get_id());
          if (document != NULL)
            {
              if (*document == *(*git))
                ;
              else
                difflist.push_back(ChangedDocument(*(*git), *document));
            }
        }
    }
  return difflist;
}

std::list<ChangedDocument> GalleryList::get_removed_documents(const GalleryList *g) const
{
  std::list<ChangedDocument> difflist;
  for (GalleryList::const_iterator it = begin(); it != end(); it++)
    {
      for (Gallery::const_iterator git = (*it)->begin(); git != (*it)->end(); 
           git++)
        {
          Document *document = g->find_doc_by_id((*git)->get_id());
          if (document == NULL)
            difflist.push_back(ChangedDocument(*(*git), Document()));
        }
    }
  return difflist;
}

GalleryList::GalleryList()
{
}

GalleryList::~GalleryList()
{
  for (iterator it = begin(); it != end(); it++)
    delete (*it);
  clear();
}

        
void GalleryList::update_thumbnails()
{
  for (iterator it = begin(); it != end(); it++)
    (*it)->update_thumbnails();
}

void GalleryList::find_deleted_documents(std::list<Document*> &removed_docs)
{
  for (iterator it = begin(); it != end(); it++)
    (*it)->find_deleted_documents(removed_docs);
}


