// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_DOCUMENT_H
#define TAPIOCA_DOCUMENT_H

#include <gtkmm.h>
#include <string>
#include "item.h"

#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/list.hpp>



namespace Tapioca 
{
class Document: public Item
{
    public:

	//! Copy constructor.
        Document(const Document& document);

	//! Create an empty document.
	Document();

	//! Destructor.
        virtual ~Document();

        // Set Methods
        
        void set_thumbnail(std::string file);
        //void set_thumbnail(Glib::RefPtr<Gdk::Pixbuf> thumb) {thumbnail = thumb;}
        void set_thumbnail_from_data(std::list<gchar> data) {thumbnail_file_data = data; update_thumbnail_from_loaded_data();};
        
        void update_thumbnail_from_loaded_data();

        void set_gallery_id(std::string id) {gallery_id = id;}

        void set_image_filename(std::string f);

        //Get Methods

        Glib::RefPtr<Gdk::Pixbuf> get_thumbnail() const {return thumbnail;}

        std::string get_gallery_id() const {return gallery_id;}

        std::string get_image_filename() const {return image_filename;}

        //operators
        bool operator==(const Document &other)
          {
            return id == other.id && 
              latitude == other.latitude &&
              longitude == other.longitude &&
              title == other.title &&
              description == other.description &&
              gallery_id == other.gallery_id &&
              order == other.order &&
              tags == other.tags &&
              thumbnail_filename == other.thumbnail_filename &&
              thumbnail_file_data == other.thumbnail_file_data &&
              image_filename == other.image_filename;
          }
    protected:

    private:
        Glib::RefPtr<Gdk::Pixbuf> thumbnail;
        std::string thumbnail_filename;
        std::list<gchar> thumbnail_file_data;
        std::string gallery_id;
        std::string image_filename;
        friend class boost::serialization::access;
                             
        template<class Archive>
          void serialize(Archive & ar, const unsigned int version)
            {
              ar & id;
              ar & latitude;
              ar & longitude;
              ar & title;
              ar & description;
              ar & gallery_id;
              ar & order;
              ar & tags;
              ar & thumbnail_filename;
              ar & thumbnail_file_data;
              ar & image_filename;
            }
                
};
}

#endif // TAPIOCA_DOCUMENT_H

