// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include "document.h"

#include <fstream>
#include <cstdio>
using namespace Tapioca;

Document::Document(const Document& d)
  :Item(d), thumbnail(d.thumbnail), thumbnail_filename(d.thumbnail_filename), thumbnail_file_data(d.thumbnail_file_data), gallery_id(d.gallery_id), image_filename(d.image_filename)
{
}

Document::Document()
: Item(), thumbnail(0), thumbnail_filename(""), gallery_id(""), image_filename("")
{
}

Document::~Document()
{
}
        
void Document::set_thumbnail(std::string filename)
{
  thumbnail_filename = filename;
  thumbnail = Gdk::Pixbuf::create_from_file(filename);
  FILE *fileptr = fopen (filename.c_str(), "rb");
  thumbnail_file_data.clear();
  if (fileptr != NULL)
    {
      gchar block[1024];
      while (!feof(fileptr))
        {
          size_t n = fread(block, sizeof (gchar), 1024, fileptr);
          for (unsigned int i = 0; i < n; i++)
            thumbnail_file_data.push_back(block[i]);
        }
      fclose(fileptr);
    }
}

void Document::update_thumbnail_from_loaded_data()
{
  size_t len = thumbnail_file_data.size();
  gchar *data = (gchar *) malloc(len * sizeof (gchar));
  size_t count = 0;
  for (std::list<gchar>::iterator i = thumbnail_file_data.begin(); 
       i != thumbnail_file_data.end(); i++)
    {
      data[count] = (*i);
      count++;
    }
  std::string temp_filename = PACKAGE_NAME ".XXXX";
  int fd = Glib::mkstemp(temp_filename);
  close(fd);
  Glib::file_set_contents(temp_filename, data, len);
  thumbnail = Gdk::Pixbuf::create_from_file(temp_filename);
  remove(temp_filename.c_str());
}

void Document::set_image_filename(std::string f)
{
  image_filename = f;
  //now make a new thumb.
  //what size of thumb does atpic make?
  //160 pixels in the largest dimension
  Glib::RefPtr<Gdk::Pixbuf> image = Gdk::Pixbuf::create_from_file(f);
  size_t width = image->get_width();
  size_t height = image->get_height();
  size_t new_width, new_height = 0;
  size_t max_thumb_size = 160;
  if (width > height)
    {
      new_width = max_thumb_size;
      new_height = height * (float)((float)max_thumb_size / (float)width);
    }
  else
    {
      new_height = max_thumb_size;
      new_width = width * (float)((float)max_thumb_size / (float)height);
    }
  Glib::RefPtr<Gdk::Pixbuf> thumb = 
    image->scale_simple(new_width, new_height, Gdk::INTERP_NEAREST);
  std::string temp_filename = PACKAGE_NAME ".png.XXXX";
  int fd = Glib::mkstemp(temp_filename);
  close(fd);
  thumb->save(temp_filename, "png");
  set_thumbnail(temp_filename);
  remove(temp_filename.c_str());
}
