//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_CONNECT_DIALOG_H
#define TAPIOCA_CONNECT_DIALOG_H

#include <gtkmm.h>
#include <gconfmm.h>
#include "profile.h"
using namespace Tapioca;

class ConnectDialog
{
 public:
    ConnectDialog(Tapioca::Profile *p);
    ~ConnectDialog();

    void set_parent_window(Gtk::Window &parent);

    int run();
    void hide();

 protected:

 private:
    Tapioca::Profile *profile;
    Gtk::Dialog* dialog;
    Gtk::Entry *username_entry;
    Gtk::Entry *password_entry;

    //callbacks
    void on_username_changed();
    void on_password_changed();

};

#endif // TAPIOCA_CONNECT_DIALOG_H
