//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <gtkmm.h>

#include "connect-dialog.h"
#include "main.h"
#include "ucompose.hpp"
#include "profile.h"

ConnectDialog::ConnectDialog(Tapioca::Profile *p)
{
  profile = p;
  Glib::RefPtr<Gtk::Builder> xml
    = Gtk::Builder::create_from_file(Main::get_glade_path()
                                     + "/connect-dialog.gtk");

  xml->get_widget("dialog", dialog);
  dialog->set_icon_from_file(Main::get_data_path() + "/icon.png");

  xml->get_widget("username_entry", username_entry);
  xml->get_widget("password_entry", password_entry);

  username_entry->signal_changed().connect
    (sigc::mem_fun(this,&ConnectDialog::on_username_changed));
  password_entry->signal_changed().connect
    (sigc::mem_fun(this,&ConnectDialog::on_password_changed));
}

ConnectDialog::~ConnectDialog()
{
  delete dialog;
}

void ConnectDialog::set_parent_window(Gtk::Window &parent)
{
  dialog->set_transient_for(parent);
}

void ConnectDialog::hide()
{
  dialog->hide();
}

int ConnectDialog::run()
{
  return dialog->run();
}

void ConnectDialog::on_username_changed()
{
  if (profile)
    profile->set_username(username_entry->get_text());
}

void ConnectDialog::on_password_changed()
{
  if (profile)
    profile->set_password(password_entry->get_text());
}
