<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------



require_once($language_path . 'search.lang.php');

if (!empty($_REQUEST['tag']) || isset($_REQUEST['v']) && $_REQUEST['v'] == "t") { // tags

	// Fetch tag-cloud
	$query = "
		SELECT t.webspace_id, t.webpage_id, t.connection_id,
		t.plugin_name, t.plugin_item_id, t.tag_name, COUNT(t.tag_name) AS total_nr_of_tags
		FROM " . $db->prefix . "_tag t
		WHERE t.webspace_id=" . $_REQUEST['ws'] . "
		GROUP BY t.tag_name ORDER BY t.tag_name"
	;

	$tags = $db->Execute($query);

	if (!empty($tags)) {
		$body->set('tags', $tags);
	}
	
	if (!empty($_REQUEST['tag'])) {
	
		$queries = array(); // init the array
		foreach(glob('components/*/inc/plugin_tags.inc.php') as $f):
			include $f;
		endforeach;
		
		$query = implode(' UNION ', $queries);
		$query .= " ORDER BY item_id";
		$result = $db->Execute($query);
		
		
		if (isset($result[0])) {
		
			foreach($result as $key => $r):
				if (function_exists('getTagLink_' . $r['plugin_name'])) {
					$function = 'getTagLink_' . $r['plugin_name'];
					$result[$key]['link'] = $function($r['item_id'], $r['webpage_id'], $_REQUEST['ws']);
				}
			endforeach;
		
			$body->set('search_result_tags', $result);
		}
	}
}
elseif (isset($_REQUEST['v']) && $_REQUEST['v'] == "r") { // ratings

	$from = isset($_GET['_frm']) ? (int) $_GET['_frm'] : 0;
	
	$days_ago = 0;
	if (isset($_REQUEST['rate_period']) && $_REQUEST['rate_period'] != "0") {
		$days_ago = " AND r.rate_create_datetime  > (now() - INTERVAL " . $_REQUEST['rate_period'] . " day ) ";
	}

	$query = "
		SELECT COUNT(distinct plugin_name, plugin_item_id) AS total
		FROM " . $db->prefix . "_rate
		WHERE webspace_id=" . $_REQUEST['ws'] . ""
	;

	$result = $db->Execute($query);
	if (isset($result[0])) {
		$total = $result[0]['total'];

		$body->set('total_nr_of_rows', $total);
	}
	
	$query = "
		SELECT COUNT(*)/COUNT(DISTINCT plugin_name, plugin_item_id) AS avg_num_votes, 
		SUM(rate_value)/COUNT(*) AS avg_rating
		FROM am_rate
		WHERE webspace_id=" . $_REQUEST['ws'] . ""
	;

	$result = $db->Execute($query);
	
	$avg_num_votes = $result[0]['avg_num_votes'];
	$avg_rating = $result[0]['avg_rating'];

	$queries = array(); // init the array
	foreach(glob('components/*/inc/plugin_ratings.inc.php') as $f):
		include $f;
	endforeach;
		
	$query = implode(' UNION ', $queries);
	$query .= " ORDER BY br DESC"; 
	$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);

	if (!empty($result[0])) {
		foreach($result as $key => $r):
			if (function_exists('getRatingLink_' . $r['plugin_name'])) {
				$function = 'getRatingLink_' . $r['plugin_name'];
				$result[$key]['link'] = $function($r['item_id'], $r['webpage_id'], $_REQUEST['ws']);
			}
		endforeach;
		$body->set('search_result_ratings', $result);
	}
}
else { // standard search



	if (!empty($_REQUEST['search_text'])) {
		
		$search_text = $_REQUEST['search_text'];
	
		// error for empty search texts
	
		if (empty($_REQUEST['search_type'])) {
			$_REQUEST['search_type'] = "comment";
		}
		
		if (is_file("components/" . $_REQUEST['search_type'] . "/inc/plugin_search.inc.php")) {
			require_once ("components/" . $_REQUEST['search_type'] . "/inc/plugin_search.inc.php");
		}
	
		if (isset($search_result)) {
			$body->set('search_result', $search_result);
		}
	}

		// get applicable search plugins
	if ($handle = opendir('components')) {
		while (false !== ($file = readdir($handle))) {
			if ($file != "." && $file != ".." && $file != "core") {
				$output_plugins[] = $file;
			}
		}
		closedir($handle);
	}
	
	$output_search_types = array();
	
	if (!empty($output_plugins)) {
		foreach($output_plugins as $key => $p):
			if (is_file("components/" . $p . "/inc/plugin_search.inc.php")) {
				array_push ($output_search_types, $p);
			}
		endforeach;
	}
	
	$body->set('search_types', $output_search_types);
}

?>