<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


class Database {

	// the constructor
	// Tom Calthrop, 26th March 2007
	//
	function Database($db_core_config) {
		$this->db_config = $db_core_config;
		$this->prefix = $db_core_config['prefix'];
	} //EO Database


	function newConnection() {
		//we connect to the database
		$this->connection = @mysql_connect($this->db_config['host'], $this->db_config['user'] , $this->db_config['pass']);

		if (!is_resource($this->connection)) {
			$GLOBALS['am_error_log'][] = array('db_error', mysql_error());
		}
		else {
			//we select the database
			$db_selected = mysql_select_db($this->db_config['db'], $this->connection);
			if (!$db_selected) {
				$GLOBALS['am_error_log'][] = array('db_select_error', mysql_error());
			}
			else {
				$db->prefix = $this->db_config['prefix'];

				// set up database collation
				$query = "SET NAMES 'utf8'";
				$this->Execute($query);
				$query = "SET CHARACTER SET 'utf8'";
				$this->Execute($query);
			}
		}
	}

	function Execute($query, $rows=null, $offset=null) {
		
		$query = trim($query);

		if (!isset($this->connection)) {
			$this->newConnection();
		}
		
		if (isset($rows) && is_int($rows) && $rows > 0) { // is_numeric
			
			if (isset($offset) && is_int($offset) && $offset > 0) { // is_numeric
				$query .= " LIMIT " . $offset . ", " . $rows;
			}
			else {
				$query .= " LIMIT " . $rows;
			}
		}

		$this->resource = mysql_query($query, $this->connection);
		
		if (!$this->resource) {
			$GLOBALS['am_error_log'][] = array('db_error', mysql_error());
		}
		else {

			if (is_resource($this->resource)) { // SELECT, SHOW, DESCRIBE or EXPLAIN
				
				if (mysql_num_rows($this->resource) > 0) {
					$result = array();
					while($row = mysql_fetch_array($this->resource)) {
						$result[] = $row;
					}
					//mysql_free_result($resource);
					return $result;
				}
				else {
					return array(); // empty result
				}
			}
			return 1; // It's ok if we reach here!
		}
		return 0; // Not OK
	}
	
	// if magic quotes disabled, use stripslashes()
	function qstr($s) {
		
		if (!get_magic_quotes_gpc()) {
 			$s = addslashes($s);
		}
		return "'" . $s . "'";
	}

	function insertID() {
		if (isset($this->connection)) {
			if (is_resource($this->connection)) {
				return mysql_insert_id ($this->connection);
			}
		}
		return 0;
	}

	function insertDb($data, $table) {
	
		$query = "
			DESCRIBE " . $table
		;
		
		$result = $this->Execute($query);
		
		$query = "INSERT INTO " . $table . "(";
		
		foreach($data as $key => $d):
			$query .= $key . ", ";
		endforeach;
		
		$query = substr($query, 0, strlen($query) - 2);
		$query .= ") VALUES (";
		
		foreach($data as $key => $d):
			
			$data_type = "";
			for ($i = 0; $i < count($result); $i++) {
				if ($key == $result[$i]['Field']) {
					$data_type = $result[$i]['Type'];
				}
			}
			
			if ($data_type == 'datetime') {
				$query .= $this->qstr(date('Y-m-d H:i:s', $d)) . ", ";
			}
			elseif (is_string($d)) {
				$query .= $this->qstr($d, get_magic_quotes_gpc()) . ", ";
			}
			else {
				$query .= $d . ", ";
			}
		endforeach;
		
		$query = substr($query, 0, strlen($query) - 2);
		$query .= ")";
		//echo $query;
		return $this->Execute($query);
	}

	function dbTime () {
		$dbtime = date("Y-m-d H:i:s");
		return $this->qstr($dbtime);
	}
}
?>