<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<style type="text/css">
<!--
@import url(<?php echo $template_path_core;?>css/aroundme_form.css);
-->
</style>


<form action="index.php?amn=core_participation" method="post" name="frm" id="id_frm">
<input type="hidden" name="item_id" value="<?php echo $item['item_id'];?>" />
<input type="hidden" name="module_id" value="<?php echo $module_id;?>" />

<?php
if (isset($participation)) {
?>

<div class="col_left1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_my_participation'];?></h1>
			</div>
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $item['item_title'];?></b><br />
					<?php echo $item['item_synopsis'];?><br />
				</p>
				
				<?php
				if (isset($identities)) {
				?>
				
				<p>
					<?php echo $lang['txt_join_intro'];?><br />
				</p>
				
				<p>
					<label for="id_identity">identity</label>
					<select id="id_identity" name="identity_id">
						<option value="0"><?php echo $lang['txt_none'];?></option>
						<?php
						foreach ($identities as $key => $i):
						
						$selected = "";
						if ($participation['identity_id'] == $i['identity_id']) {
							$selected = "selected=\"selected\"";
						}
						?>
						<option value="<?php echo $i['identity_id'];?>" <?php echo $selected;?>><?php echo $i['identity_name'];?></option>
						<?php
						endforeach;
						?>
					</select>
				</p>
				<?php }?>
				
				<hr />
				
				
				<p align="right">
					<?php
					if (isset($participation['user_id'])) { // we are not the item owner
						if ($participation['status_id'] == $core_config['participation']['status']['withdrawn']) { // we are not the item owner
						?>
						<input type="submit" name="my_participation_activate" class="input_submit" value="<?php echo $lang['sub_activate'];?>" />&nbsp;
						<?php
						}
						else {
						?>
						<input type="submit" name="my_participation_withdraw" class="input_submit" value="<?php echo $lang['sub_withdraw'];?>" />&nbsp;
						<?php }?>
					<?php
					}
					else {
					?>
					<input type="submit" name="my_participation_update" class="input_submit" value="<?php echo $lang['sub_join'];?>" /><br />
					<?php }?>
				</p>
			</div>
		</div>
	</div>
	
	<?php
	if (isset($relations)) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_relations'];?></h1>
			</div>
		</div>
			
		<div class="box_mid">
			<div class="content">
				
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
					<?php
					foreach($relations as $key => $i):
					?>
					<tr>
						<td valign="top" width="32">	
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $module_id;?>&amp;item_id=<?php echo $item['item_id'];?>&identity_id=<?php echo $i['identity_id'];?>"><img src="get_file.php?file=<?php echo $i['identity']['image']['file_md5_name_view'];?>&amp;type=<?php echo $i['identity']['image']['file_type'];?>&amp;directory=<?php echo $i['identity']['image']['directory']."/";?>" border="0" class="picture" alt="" /></a><br />
						</td>
						<td valign="top">
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $module_id;?>&amp;item_id=<?php echo $item['item_id'];?>&amp;identity_id=<?php echo $i['identity_id_relation'];?>"><?php echo $i['identity']['identity_nic'];?></a><br />
						</td>
						<td valign="top" align="right">
							<?php
							if (isset($i['mutual'])) {
							?>
							(<?php echo $lang['txt_mutual'];?>)
							<?php }?>
							<br />
						</td>
						<td valign="top" align="right">
							<?php echo $this->date->formatDate($i['relation_create_datetime']);?><br />
						</td>
						<td align="right" valign="top">
							<input type="checkbox" name="identity_ids[]" value="<?php echo $i['identity_id_relation'];?>" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				
				<hr />
				
				<p align="right">
					<input type="submit" name="remove_relations" class="input_submit" value="<?php echo $lang['sub_remove_relations'];?>" />
				</p>
			</div>
		</div>
	</div>
	<?php }?>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_participants'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if ($participation['participation_permission'] & $item_config['resource']['user']['manage_participants']) {
				?>
				<p align="right">
					<a href="index.php?amn=core_participation_edit&amp;module_id=<?php echo $module_id;?>&amp;item_id=<?php echo $item['item_id'];?>">manage participants</a><br />
				</p>
				<?php }?>
				
				<?php
				if (isset($participants)) {
				?>
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
					<?php
					foreach($participants as $key => $i):
					?>
					<tr>
						<td valign="top" width="32">	
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $module_id;?>&amp;item_id=<?php echo $item['item_id'];?>&identity_id=<?php echo $i['identity_id'];?>"><img src="get_file.php?file=<?php echo $i['identity']['image']['file_md5_name_view'];?>" border="0" class="picture" alt="<?php echo isset($i['identity']['image']['file_save_name']) ? $i['identity']['image']['file_save_name'] : $lang['alt_no_image']; ?>" /></a><br />
						</td>
						<td valign="top">
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $module_id;?>&amp;item_id=<?php echo $item['item_id'];?>&amp;identity_id=<?php echo $i['identity_id'];?>"><?php echo $i['identity']['identity_nic'];?></a><br />
						</td>
						<td valign="top" align="right">
							<?php echo $this->date->formatDate($i['participation_create_datetime']);?><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				}
				else {
				?>
					<p>
						<?php echo $lang['template_error']['err_no_items'];?><br />
					</p>
				<?php }?>
			</div>
		</div>
	</div>
</div>

<?php
}
else { // needs to register first
?>

<div class="col_left1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_join'];?></h1>
			</div>
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $item['item_title'];?></b><br />
					<?php echo $item['item_synopsis'];?><br />
				</p>
				
				<p>
					<?php echo $lang['txt_select_identity'];?><br />
				</p>
						
				<?php
				if (isset($identities)) {
				?>
				<p>
					<label for="id_identity">identity</label>
					<select id="id_identity" name="identity_id">
						<option value="0"><?php echo $lang['txt_none'];?></option>
						<?php
						foreach ($identities as $key => $i):
						
						$selected = "";
						if ($participation['identity_id'] == $i['identity_id']) {
							$selected = "selected=\"selected\"";
						}
						?>
						<option value="<?php echo $i['identity_id'];?>" <?php echo $selected;?>><?php echo $i['identity_name'];?></option>
						<?php
						endforeach;
						?>
					</select>
				</p>
				<?php }?>
				
				<hr />
				
				
				<p align="right">
					<?php
					if (isset($invite)) {
					?>
					<input type="submit" name="accept_invite" class="input_submit" value="<?php echo $lang['sub_invitation'];?>" /><br />
					<?php
					}
					else {
					?>
					<input type="submit" name="my_participation_insert" class="input_submit" value="<?php echo $lang['sub_join'];?>" /><br />
					<?php }?>
				</p>
			</div>
		</div>
	</div>
</div>

<div class="col_right1">
	<?php
	if (isset($invitee_identity)) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_invite'];?></h1>
			</div>
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				$id_card = $invitee_identity;
				include($template_path_core . "inc/identity.inc.php");
				?>
			</div>
		</div>
	</div>
	<?php }?>

	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_participation'];?></h1>
			</div>
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['item_type_desc'][$item['item_type']];?><br />
			</div>
		</div>
	</div>
</div>		
<?php }?>
</form>