# This file is part of AROUNDMe
#  
# Copyright (C) 2003, 2005 Barnraiser
# http://www.barnraiser.org/
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with program; see the file COPYING. If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
# 

# Table structure for table `am_abuse`
CREATE TABLE `am_abuse` (
  `abuse_id` int(11) NOT NULL auto_increment,
  `abuse_url` varchar(255) default NULL,
  `abuse_source` text,
  `reportee_user_id` int(11) default NULL,
  `assigned_user_id` int(11) default NULL,
  `abuse_note` text,
  `reportee_language_id` int(3) default NULL,
  `report_datetime` datetime default NULL,
  `report_status_id` int(11) default NULL,
  PRIMARY KEY  (`abuse_id`)
) TYPE=InnoDB CHARACTER SET utf8 COMMENT='record of all instances of reported abuse';


# Table structure for table `am_acs_group_role`
CREATE TABLE `am_acs_group_role` (
  `role_id` int(11) NOT NULL auto_increment,
  `role_name` varchar(255) default NULL,
  `group_id` int(11) default NULL,
  `role_default` int(1) default NULL,
  `role_visitor` int(1) default NULL,
  PRIMARY KEY  (`role_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_acs_permission`
CREATE TABLE `am_acs_permission` (
  `role_id` int(3) default NULL,
  `role_type` int(1) default NULL,
  `privilege_id` int(3) default NULL,
  `resource_id` int(3) default NULL
) TYPE=InnoDB CHARACTER SET utf8 COMMENT='access control system';


# Table structure for table `am_blog`
CREATE TABLE `am_blog` (
  `blog_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `blog_title` varchar(255) default NULL,
  `blog_synopsis` varchar(255) default NULL,
  `blog_body` text,
  `language_id` int(3) default NULL,
  `blog_create_datetime` datetime default NULL,
  `blog_edit_datetime` datetime default NULL,
  `blog_allow_comments` int(1) default NULL,
  `file_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`blog_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_bookmark`
CREATE TABLE `am_bookmark` (
  `item_id` int(11) default NULL,
  `rsp_item_type_id` int(3) default NULL,
  `bookmark_type` int(1) default NULL,
  `user_id` int(11) default NULL,
  `bookmark_lastview_datetime` datetime default NULL,
  `bookmark_alarm_datetime` datetime default NULL,
  `bookmark_notify` int(1) default NULL,
  `bookmark_batch_request` int(1) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_channel`
CREATE TABLE `am_channel` (
  `channel_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `channel_url` varchar(255) default NULL,
  `language_id` int(3) default NULL,
  `channel_title` varchar(255) default NULL,
  `channel_synopsis` varchar(255) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`channel_id`)
) TYPE=InnoDB CHARACTER SET utf8;
    


# Table structure for table `am_comment`
CREATE TABLE `am_comment` (
  `comment_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `comment_parent_id` int(11) default NULL,
  `item_id` int(11) default NULL,
  `rsp_item_type_id` int(3) default NULL,
  `comment_body` text,
  `comment_create_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  `item_user_id` int(11) default NULL,
  PRIMARY KEY  (`comment_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_file`
CREATE TABLE `am_file` (
  `file_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `file_name` varchar(50) default NULL,
  `file_suffix` varchar(4) default NULL,
  `file_create_datetime` datetime default NULL,
  `file_title` varchar(255) default NULL,
  `file_size` int(11) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`file_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_forum_subject`
CREATE TABLE `am_forum_subject` (
  `subject_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `topic_id` int(11) default NULL,
  `subject_title` varchar(255) default NULL,
  `file_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `subject_hidden` int(1) default NULL,
  `subject_synopsis` varchar(255) default NULL,
  `subject_body` text,
  `subject_create_datetime` datetime default NULL,
  `subject_edit_datetime` datetime default NULL,
  `subject_locked` int(1) default NULL,
  `subject_sticky` int(1) default NULL,
  PRIMARY KEY  (`subject_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_forum_topic`
CREATE TABLE `am_forum_topic` (
  `topic_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `topic_title` varchar(50) default NULL,
  `topic_synopsis` varchar(255) default NULL,
  `topic_hidden` int(1) default NULL,
  `topic_order` int(3) default NULL,
  `topic_create_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`topic_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_forum_topic_role`
CREATE TABLE `am_forum_topic_role` (
  `topic_id` int(11) default NULL,
  `role_id` int(11) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_group`
CREATE TABLE `am_group` (
  `group_id` int(11) NOT NULL auto_increment,
  `group_title` varchar(255) default NULL,
  `group_unix_title` varchar(8) default NULL,
  `group_synopsis` varchar(255) default NULL,
  `group_home_synopsis` text,
  `group_rules` text,
  `language_id` int(3) default NULL,
  `group_create_datetime` datetime default NULL,
  `group_registration_type` int(11) default NULL,
  `group_from_age` int(11) default NULL,
  `group_to_age` int(11) default NULL,
  `group_rsp_auto_publish` int(1) default NULL,
  `user_id` int(11) default NULL,
  `file_id` int(11) default NULL,
  `group_visibility` int(1) default NULL,
  `group_file_allocation` int(11) default NULL,
  `status_id` int(3) default NULL,
  PRIMARY KEY  (`group_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_group_custom_item`
CREATE TABLE `am_group_custom_item` (
`group_id` INT( 11 ) NOT NULL ,
`custom_item_id` INT( 3 ) NOT NULL ,
`custom_item_body` VARCHAR( 50 ) NOT NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_group_member`
CREATE TABLE `am_group_member` (
  `group_member_id` int(11) NOT NULL auto_increment,
  `group_member_number` varchar(100) default NULL,
  `group_id` int(11) default NULL,
  `status_id` int(3) default NULL,
  `role_id` int(11) default NULL,
  `group_member_create_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  `profile_id` int(11) default NULL,
  PRIMARY KEY  (`group_member_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_library`
CREATE TABLE `am_library` (
  `library_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `library_page_name` varchar(100) default NULL,
  `library_default` int(1) default NULL,
  `library_title` varchar(255) default NULL,
  `library_synopsis` text,
  `library_body` text,
  `language_id` int(3) default NULL,
  `file_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `library_allow_comments` int(1) default NULL,
  `library_create_datetime` datetime default NULL,
  PRIMARY KEY  (`library_id`)
) TYPE=InnoDB CHARACTER SET utf8;

# Table structure for table `am_newsletter`
CREATE TABLE `am_newsletter` (
  `message_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `from_user_id` int(11) default NULL,
  `to_type_id` int(11) default NULL,
  `message_subject` varchar(50) default NULL,
  `message_body` text,
  `message_create_datetime` datetime default NULL,
  `item_id` int(11) default NULL,
  `role_id` int(11) default NULL,
  `language_id` int(11) default NULL,
  `start_user_id` int(11) default NULL,
  `status_id` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`message_id`)
) TYPE=InnoDB CHARACTER SET utf8;

# Table structure for table `am_poll`
CREATE TABLE `am_poll` (
  `poll_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `poll_question` varchar(255) default NULL,
  `poll_body` text,
  `poll_start_datetime` datetime default NULL,
  `poll_end_datetime` datetime default NULL,
  `poll_anon` int(1) default NULL,
  `user_id` int(11) default NULL,
  `poll_create_datetime` datetime default NULL,
  `poll_edit_datetime` datetime default NULL,
  `vote_required` int(1) default NULL,
  PRIMARY KEY  (`poll_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_poll_answer`
CREATE TABLE `am_poll_answer` (
  `answer_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `poll_id` int(11) default NULL,
  `option_id` int(11) default NULL,
  `current_answer` int(1) default NULL,
  `answer_create_datetime` datetime default NULL,
  PRIMARY KEY  (`answer_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_poll_option`
CREATE TABLE `am_poll_option` (
  `option_id` int(11) NOT NULL auto_increment,
  `poll_id` int(11) default NULL,
  `option_body` varchar(255) default NULL,
  `option_create_datetime` datetime default NULL,
  `option_edit_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`option_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_quiz`
CREATE TABLE `am_quiz` (
  `quiz_id` int(11) NOT NULL auto_increment,
  `quiz_title` varchar(100) default NULL,
  `quiz_body_intro` text,
  `quiz_body_exit_pass` text,
  `quiz_body_exit_fail` text,
  `quiz_pass_rate` int(3) default NULL,
  `group_id` int(11) default NULL,
  `quiz_synopsis` varchar(255) default NULL,
  `quiz_start_datetime` datetime default NULL,
  `quiz_end_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  `quiz_create_datetime` datetime default NULL,
  `quiz_edit_datetime` datetime default NULL,
  `quiz_retake_daycount` int(3) default NULL,
  `quiz_display_answers` int(1) default NULL,
  `quiz_display_results` int(1) default NULL,
  `quiz_allow_comments` int(1) default NULL,
  `file_id` int(11) default NULL,
  PRIMARY KEY  (`quiz_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_quiz_option`
CREATE TABLE `am_quiz_option` (
  `option_id` int(11) NOT NULL auto_increment,
  `question_id` int(11) default NULL,
  `option_body` varchar(255) default NULL,
  PRIMARY KEY  (`option_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_quiz_question`
CREATE TABLE `am_quiz_question` (
  `question_id` int(11) NOT NULL auto_increment,
  `quiz_id` int(11) default NULL,
  `question_body` varchar(255) default NULL,
  `question_answer` text,
  `question_order` char(3) default NULL,
  `question_correct_option_id` varchar(11) default NULL,
  PRIMARY KEY  (`question_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_quiz_result`
CREATE TABLE `am_quiz_result` (
  `result_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `quiz_id` int(11) default NULL,
  `result_create_datetime` datetime default NULL,
  `result_mark` int(1) default NULL,
  PRIMARY KEY  (`result_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_rsp`
CREATE TABLE `am_rsp` (
  `item_id` int(11) default NULL,
  `group_id` int(11) default NULL,
  `item_name` VARCHAR(50) default NULL,
  `rsp_item_type_id` int(2) default NULL,
  `rsp_publish_datetime` datetime default NULL,
  `status_id` int(1) default NULL,
  `level_id` int(1) default NULL,
  `degree_id` int(1) default NULL,
  `language_id` int(3) default NULL,
  `rsp_sticky` int(1) default NULL,
  `rsp_featured` int(1) default NULL
) TYPE=InnoDB CHARACTER SET utf8 COMMENT='really simple publishing system';


# Table structure for table `am_schedule`
CREATE TABLE `am_schedule` (
  `schedule_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `schedule_type_id` int(3) default NULL,
  `schedule_create_datetime` datetime default NULL,
  `schedule_start_datetime` datetime default NULL,
  `schedule_end_datetime` datetime default NULL,
  `schedule_title` varchar(255) default NULL,
  `schedule_synopsis` text,
  `schedule_body` text,
  `schedule_location` varchar(255) default NULL,
  `schedule_occurence` int(11) default NULL,
  `schedule_repeat_until` date default NULL ,
  `file_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `schedule_category_id` int(11) default NULL,
  `status_id` int(11) default NULL,
  `schedule_priority_id` int(3) default NULL,
  `schedule_p_complete` int(3) default NULL,
  `schedule_complete` int(1) default NULL,
  `schedule_allocation` int(11) default NULL,
  `schedule_allow_comments` INT(1) default NULL,
  `language_id` INT(3) default NULL,
  PRIMARY KEY  (`schedule_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_schedule_allocation`
CREATE TABLE `am_schedule_allocation` (
  `schedule_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `schedule_allocation_create_datetime` datetime default NULL,
  `status_id` int(2) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_shoutbox`
CREATE TABLE `am_shoutbox` (
  `shoutbox_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `shoutbox_body` varchar(200) default NULL,
  `shoutbox_create_datetime` datetime default NULL,
  PRIMARY KEY  (`shoutbox_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_sn`
CREATE TABLE `am_sn` (
  `user_id` int(11) default NULL,
  `degree_id` int(3) default NULL,
  `sn_total` int(11) default NULL,
  `sn_update_datetime` datetime default NULL,
  `sn_batch_request` int(1) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_statistic`
CREATE TABLE `am_statistic` (
  `group_id` int(11) default NULL,
  `statistic_type_id` int(3) default NULL,
  `total` int(11) default NULL,
  `user_id` int(11) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_tag`
CREATE TABLE `am_tag` (
  `group_id` int(11) default NULL,
  `item_id` int(11) default NULL,
  `item_name` varchar(50) default NULL,
  `rsp_item_type_id` int(3) default NULL,
  `tag_body` varchar(50) default NULL,
  `user_id` int(11) default NULL,
  `level_id` int(1) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_template`
CREATE TABLE `am_template` (
  `template_id` int(11) NOT NULL auto_increment,
  `template_title` varchar(50) default NULL,
  PRIMARY KEY  (`template_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user`
CREATE TABLE `am_user` (
  `user_id` int(11) NOT NULL auto_increment,
  `user_number` varchar(50) default NULL,
  `user_firstname` varchar(100) default NULL,
  `user_surname` varchar(100) default NULL,
  `user_email` varchar(100) NOT NULL default '',
  `user_hometown` varchar(100) default NULL,
  `user_dob` date default NULL,
  `user_gender` int(1) default NULL,
  `language_id` int(3) default NULL,
  `template_id` int(3) default NULL,
  `user_homepage` varchar(50) default NULL,
  `status_id` int(3) default NULL,
  `role_id` int(11) default NULL,
  `user_password` varchar(32) NOT NULL default '',  
  `user_feed_password` varchar(6) default NULL,
  `user_create_datetime` datetime default NULL,
  `active_time` timestamp(14) NOT NULL,
  `user_file_allocation` int(11) default NULL,
  PRIMARY KEY  (`user_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_blocked`
CREATE TABLE `am_user_blocked` (
  `user_id_blocker` int(11) default NULL,
  `user_id_blocked` int(11) default NULL,
  `block_datetime` datetime default NULL,
  `block_description` varchar(200) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_invited`
CREATE TABLE `am_user_invited` (
  `invited_email` varchar(100) default NULL,
  `user_id` int(11) default NULL,
  `invite_create_datetime` datetime default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_language`
CREATE TABLE `am_user_language` (
  `user_id` int(11) default NULL,
  `language_id` int(3) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_message`
CREATE TABLE `am_user_message` (
  `message_id` int(11) NOT NULL auto_increment,
  `owner_user_id` int(11) default NULL,
  `from_user_id` int(11) default NULL,
  `to_user_id` int(11) default NULL,
  `message_status` int(3) default NULL,
  `message_box` int(3) default NULL,
  `message_subject` varchar(50) default NULL,
  `message_body` text,
  `message_create_datetime` datetime default NULL,
  `message_type` int(3) default NULL,
  PRIMARY KEY  (`message_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_preference`
CREATE TABLE `am_user_preference` (
  `user_id` INT( 11 ) ,
  `user_preference_id` INT( 3 ),
  `user_preference_value` INT( 3 )
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_profile`
CREATE TABLE `am_user_profile` (
  `profile_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `profile_true_self` int(1) default NULL,
  `profile_default` int(1) default NULL,
  `profile_name` varchar(50) default NULL,
  `profile_summary` text,
  `profile_gender` int(1) default NULL,
  `profile_nic` varchar(50) default NULL,
  `profile_hometown` varchar(50) default NULL,
  `profile_create_datetime` datetime default NULL,
  `profile_allow_msg` int(1) default NULL,
  `file_id` int(11) default NULL,
  `profile_text1` varchar(100) default NULL,
  `profile_text2` varchar(100) default NULL,
  `profile_text3` varchar(100) default NULL,
  `profile_text4` varchar(100) default NULL,
  `profile_text5` varchar(100) default NULL,
  `profile_text6` varchar(100) default NULL,
  `profile_text7` varchar(100) default NULL,
  `profile_text8` varchar(100) default NULL,
  `profile_text9` varchar(100) default NULL,
  `profile_text10` varchar(100) default NULL,
  PRIMARY KEY  (`profile_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_relation`
CREATE TABLE `am_user_relation` (
  `user_id` int(11) default NULL,
  `user_id_relation` int(11) default NULL,
  `relation_create_datetime` datetime default NULL,
  `relation_type_id` int(3) default NULL,
  `relation_show_true_self` int(1) default NULL,
  `relation_show_network` int(1) default NULL
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_session`
CREATE TABLE `am_user_session` (
  `session_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `session_md5` varchar(32) default NULL,
  `session_lastused` timestamp(14) NOT NULL,
  `session_firstused` timestamp(14) NOT NULL,
  `session_ip` varchar(15) default NULL,
  PRIMARY KEY  (`session_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# Table structure for table `am_user_skill`
CREATE TABLE `am_user_skill` (
  `skill_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `skill_name` varchar(200) default NULL,
  `skill_rating` int(3) default NULL,
  `skill_experience` text,
  `degree_id` int(3) default '1',
  PRIMARY KEY  (`skill_id`)
) TYPE=InnoDB CHARACTER SET utf8;


# INSERT DEFAULTS -----------------------------------------

INSERT INTO `am_template` VALUES (1, 'barnraiser_01');