<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['administration'], $c_acs['arr_acs']['privilege']['allow_group_mgmt'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');


//setup group admin class
require_once('class/Group.class.php');
require_once('class/GroupAdmin.class.php');
$groupadm = new GroupAdmin($db, $me);
$groupadm->date = $date;
$groupadm->member_status_id = $c_node['group']['member_status']['active'];


//setup group class
require_once('class/Group.class.php');
$group = new Group($db);
$group->user_id = $me['user_id'];
$group->registration_types = $c_node['group']['registration_type'];


//process requests
if (isset($_POST['update_group'])) {
	$frmdata['group_file_allocation'] = $frmdata['group_file_allocation']*1000;
	$groupadm->group_id = $frmdata['group_id'];
	$groupadm->updateAdminGroup($frmdata);
	
	if (empty($groupadm->log)) {
		return header("Location: node_group.php?group_id=" . $frmdata['group_id'] . "&amp;" . SID);
		exit;
	}
	
	
}
elseif (isset($_REQUEST['edit_group'])) {
	$group->group_id = $_REQUEST['group_id'];
	$output_group = $group->getGroup();
	
	$display = "edit_group";
}
elseif (isset($_REQUEST['group_id'])) {
	$group->group_id = $_REQUEST['group_id'];
	$output_group = $group->getGroup();
	
	$display = "view_group";
}
else {
	$output_groups = $groupadm->getAllGroups();
}


//move to template
if (!empty($output_groups)) {
	$body->set('groups', $output_groups);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('today', date("Y-m-d"));

include "inc/footer.inc.php";

?>
