<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
// Really Simple Publishing (Rsp)

class Rsp {
	// CLASS FUNCTIONS
	// Rsp
	// selRspItems
	// insertRspItem
	// deleteRspItem
	// deleteRspItems
	// updateRspItem
	// getRspByItem
	// selRspItem



	// Rsp --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 10th December 2004
	//
	function Rsp($db, $rsp_item_type_id){
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
	}//EO Rsp



	// selRspItems --------------------------------------------------------------------
	// return array of type ids
	// tom calthrop - 10th December 2004
	//
	function selRspItems() {
		$query = "
			SELECT item_id, rsp_sticky, status_id, rsp_featured 
			FROM " . $this->db->prefix . "_rsp
			WHERE "
		;

		if (!empty($this->group_id)) {
			$query .= "group_id=" . $this->group_id . " AND ";
		}

		if (isset($this->rsp_status_id)) {
			$query .= "status_id=" . $this->rsp_status_id . " and ";
		}

		if (isset($this->rsp_item_type_id)) {
			$query .= "rsp_item_type_id=" . $this->rsp_item_type_id . " and ";
		}

		if (isset($this->level_id)) {
			$query .= "level_id=" . $this->level_id . " and ";
		}

		if (isset($this->rsp_featured)) {
			$query .= "rsp_featured=" . $this->rsp_featured . " and ";
		}

		$query .= "1=1 order by rsp_publish_datetime desc";

		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selRspItems class=Rsp.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selRspItems



	// insertRspItem --------------------------------------------------------------------
	// inserts an item
	// tom calthrop - 8th Jan 2004
	//
	function insertRspItem($data) {

		if (empty($data['degree_id'])) {
		    $data['degree_id'] = "null";
		}

		if (isset($this->group_id) && $this->group_id > 0) {
		    $group_id = $this->group_id;
		}
		else {
			$group_id = "null";
		}
		
		if (empty($data['item_name'])) {
		    $data['item_name'] = "null";
		}
		
		if (empty($data['rsp_featured'])) {
		    $data['rsp_featured'] = "null";
		}
		
		$rec = array();
		$rec['group_id'] = $group_id;
		$rec['item_id'] = $data['item_id'];
		$rec['item_name'] = $data['item_name'];
		$rec['rsp_item_type_id'] = $this->rsp_item_type_id;
		$rec['rsp_publish_datetime'] = time();
		$rec['status_id'] = $this->status_id;
		$rec['level_id'] = $data['level_id'];
		$rec['degree_id'] = $data['degree_id'];
		$rec['language_id'] = $data['language_id'];
		$rec['rsp_featured'] = $data['rsp_featured'];
		
		$table = $this->db->prefix . "_rsp";
			
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=insertRspItem class=Rsp.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertRspItem



	// deleteRspItems --------------------------------------------------------------------
	// deletes multiple rsp item(s)
	// tom calthrop - 26th December 2004
	//
	function deleteRspItems($del_arr = null) {

		if (isset($del_arr)) {
		    $rownums = count($del_arr);
		}
		else {
		    $del_arr = array($this->item_id);
		}

		for ($i=0; $i < $rownums; $i++) {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_rsp
				WHERE "
			;

			$query .= "
				rsp_item_type_id=" . $this->rsp_item_type_id . " and
				level_id=" . $this->level_id . " and
				item_id=" . $del_arr[$i]
			;
			
			$result = $this->db->Execute($query);

			if (empty($result)) {
				$error_info = "function=deleteRspItems class=Rsp.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteRspItems



	// deleteRspItem --------------------------------------------------------------------
	// deletes an item
	// tom calthrop - 8th Jan 2004
	//
	function deleteRspItem($item_id=null, $item_name = null) {
		
		if (isset($item_name)) {
			$querywhere = "item_name=" . $this->db->qstr($item_name, get_magic_quotes_gpc());
		}
		else {
			$querywhere = "item_id=" . $item_id;
		}
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_rsp
			WHERE
			" . $querywhere . " AND
			rsp_item_type_id=" . $this->rsp_item_type_id . " AND "
		;
		
		if (isset($this->group_id)) {
			$query .= "group_id=" . $this->group_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteRspItem class=Rsp.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteRspItem



	// updateRspItem --------------------------------------------------------------------
	// updates rsp item(s)
	// tom calthrop - 26th December 2004
	//
	function updateRspItem($status_id, $sticky = null, $featured = null) {
		
		if (!empty($sticky)) {
		    $sticky = 1;
		}
		else {
		    $sticky = "null";
		}
		
		if (!empty($featured)) {
		    $featured = 1;
		}
		else {
		    $featured = "null";
		}
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_rsp
			WHERE 
			rsp_item_type_id=" . $this->rsp_item_type_id . " and
			level_id=" . $this->level_id . " and
			item_id=" . $this->item_id . " and "
		;
		
		if (isset($this->group_id)) {
			$query .= "group_id=" . $this->group_id . " and ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['status_id'] = $status_id;
		$rec['rsp_sticky'] = $sticky;
		$rec['rsp_featured'] = $featured;
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	} //EO updateRspItem



	// getRspByItem --------------------------------------------------------------------
	// return array
	// tom calthrop - 26th March 2005
	//
	function getRspByItem() {
		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_rsp
			WHERE
			item_id=" . $this->item_id . " AND "
		;

		if (!empty($this->group_id)) {
			$query .= "group_id=" . $this->group_id . " AND ";
		}

		$query .= "1=1";

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getRspByItem class=Rsp.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getRspByItem



	// selRspItem --------------------------------------------------------------------
	// return array
	// tom calthrop - 26th March 2005
	//
	function selRspItem($item_id) {
		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_rsp
			WHERE
			rsp_item_type_id=" . $this->rsp_item_type_id . " AND
			item_id=" . $item_id . " AND "
		;

		if (!empty($this->group_id)) {
			$query .= "group_id=" . $this->group_id . " AND ";
		}

		$query .= "1=1";

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selRspItem class=Rsp.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selRspItem
}

?>
