<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!empty($_REQUEST['group_id'])) { // page under group section
	$group_id = $_REQUEST['group_id'];
	include_once ('inc/header_group.inc.php');
	
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['library'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
else {
	if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['library'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
		exit;
	}
	unset ($group_id);
}


//setup library
require_once('class/Library.class.php');
$library = new Library($db, null, $file);


if (isset($_REQUEST['library_id'])) {
	$library->library_id = $_REQUEST['library_id'];
}
elseif (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}

if (isset($group_id)) {
    $library->group_id = $group_id;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'lib_view.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['library']);
$rsp->user_id = $me['user_id'];

if (!empty($group_id)) {
    $rsp->group_id = $group_id;
}


// SETUP WIKI ----------------------------------------------------------------------
$wiki_path = "lib_item.php?page=";
$wiki_new_path = "lib_edit.php?page=";
$wiki_image_base = "get_file.php?file=";

require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);


// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);
if (!empty($group_id)) {
    $file->group_id = $group_id;
}
else {
	$file->user_id = $me['user_id'];
}
$output_filenames = $file->getFiles();


// SETUP BOOKMARKS ---------------------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['library'], $me['user_id']);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {

	$frmdata['library_synopsis'] = htmlspecialchars($frmdata['library_synopsis']);
	$frmdata['library_title'] = htmlspecialchars($frmdata['library_title']);
	
	if (empty($frmdata['group_id'])) {
		unset($frmdata['group_id']);
	}

	if (isset($frmdata['preview'])) {
		$frmdata['library_body'] = stripslashes($frmdata['library_body']);
		$frmdata['library_synopsis'] = stripslashes($frmdata['library_synopsis']);
		$frmdata['library_title'] = stripslashes($frmdata['library_title']);
		$frmdata['library_body_preview'] = $wiki->transform($frmdata['library_body'], 'Xhtml');
		
		if (!isset($frmdata['rsp_public_featured'])) {
			$frmdata['rsp_public_featured'] = 0;
		}
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node'], 'degree_id' => $frmdata['rsp_node'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_group'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['group']['home']);
		}

		$output_library = $frmdata;

		$display = "allow_edit";
	}
	elseif (isset($_POST['edit_library_again'])) {
		$output_library = $frmdata;

		$display = "allow_edit";

	}
	elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {
		//check if wiki page name is empty
		if (!empty($frmdata['library_page_name'])) {
			$frmdata['library_page_name'] = trim($frmdata['library_page_name']);
			
			//check if wiki page name is invalid
			$pattern="/^[a-zA-Z0-9]*$/";
			
			if (!preg_match($pattern, $frmdata['library_page_name'])) {
				$GLOBALS['am_error_log'][] = array(51, null, null);
				unset($frmdata['library_page_name']);
			}
			
			// check that first character is an uppercase letter
			$pattern="/^[A-Z]*$/";
			
			if (!preg_match($pattern, substr($frmdata['library_page_name'],0,1))) {
				$GLOBALS['am_error_log'][] = array(51, null, null);
				unset($frmdata['library_page_name']);
			}
			
			if(empty($frmdata['library_id']) && !empty($frmdata['library_page_name']) && !empty($pages)) {
				//we check the new page name to see if it already exists
				foreach ($pages as $key => $i):
					if ($i == $frmdata['library_page_name']) {
						$GLOBALS['am_error_log'][] = array(48, null);
						break;
					}
				endforeach;
			}
		}
		else { //wiki page name is not set or empty
		    $GLOBALS['am_error_log'][] = array(50, null, null);
		}
		
		if (empty($frmdata['library_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if (empty($frmdata['library_synopsis'])) {
		    $GLOBALS['am_error_log'][] = array(30, null, null);
		}

		if (empty($frmdata['language_id'])) {
		    $frmdata['language_id'] = $me['language_id'];
		}

		if (empty($GLOBALS['am_error_log'])) {
			//we insert record
			
	 		$library->user_id = $me['user_id'];
	 		$library->insertLibrary($frmdata);

			if (empty($GLOBALS['am_error_log'])) {
				//insert into setup rsp
				if (!empty($frmdata['group_id'])) {
				    $temp['language_id'] = $output_group['language_id'];
				}
				else {
					$temp['language_id'] = $me['language_id'];
				}

				$temp['item_id'] = $library->library_id;
				$temp['item_name'] = $library->library_page_name;
				//delete all
				$rsp->deleteRspItem(null, $library->library_page_name);

				//insert node rsp entry
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					if (!empty($frmdata['rsp_node_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if ($frmdata['rsp_node'] == "all" || !empty($frmdata['group_id'])) {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_node'];
					}
					
					if($c_node['rsp']['node']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];
					
					if($output_group['group_rsp_auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					
					if (!empty($frmdata['rsp_public_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if($c_node['rsp']['public']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				// add bookmark tracking
				$bookmark->item_id = $library->library_id;
				$bookmark->deleteBookmark();
				if (!empty($frmdata['ins_mark'])) {
					$bookmark->insertBookmark(1);
				}
				
				//setup statistics
				require_once('class/Statistic.class.php');
				$statistic = new Statistic($db, $c_node['rsp']['item_type']['library'], $date);
				
				//update stats
				if (!empty($frmdata['group_id'])) { // page under group section
					unset($library->user_id);
					$statistic->group_id = $frmdata['group_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group']['total_library_items'];
				}
				else {
					$library->user_id = $me['user_id'];
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['user']['total_library_items'];
				}
				
				$statistic->setStatistic($library->getLibraryItemCount());
				
				//get member blog stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_library_items'];
					$statistic->setStatistic($library->getLibraryItemCount($me['user_id']));
				}
			 }

			if (empty($GLOBALS['am_error_log'])) {

				if (isset($frmdata['save_go'])) {
					header("Location: lib_view.php?library_id=" . $library->library_id . "&". strip_tags(SID));
					exit;
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: lib_edit.php?group_id=" . $frmdata['group_id'] . "&library_id=" . $library->library_id . "&". strip_tags(SID));
						exit;
					}
					else {
						header("Location: lib_edit.php?library_id=" . $library->library_id . "&". strip_tags(SID));
						exit;
					}
					
				}
			}
		}
		else { // something errored
			$output_library = $frmdata;
		}

		$display = "allow_edit";


	}
}
elseif (isset($library->library_id) && $library->library_id > 0) {
	$output_library = $library->getPageID($library->library_id);

	$display = "allow_edit";
}
elseif (isset($page)) {//else we assign the new page name
	$output_library = $library->getPageName($page);

	if (empty($output_library)) { //is a new page
	    $output_library['library_page_name'] = $page;
	}

	$display = "allow_edit";
}

if (!empty($output_library['group_id'])) {
	// we check that I am in the group and that I have permissions to view
	$group_id = $output_library['group_id'];
	include_once ('inc/header_group.inc.php');
	
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['library'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		unset($output_library, $display);
	}
}

//handle new libraries - we've deleted all library items and now adding new one
if (isset($output_library['library_page_name']) && !isset($output_library['library_id']) && ($output_library['library_page_name'] == $lang['txt_wiki_default'])) {
	$output_library['library_default'] = 1;
}


//get the author
if (isset($output_library['user_id'])) {
	$output_author = $user->selProfile($output_library['user_id']);
}


if (!empty($output_library['group_id'])) {
	$file->group_id = $output_library['group_id'];
	unset($file->user_id);
}
elseif (isset($group_id)) {
	$file->group_id = $group_id;
	unset($file->user_id);
}
else {
	$file->user_id = $me['user_id'];
	unset($file->group_id);
}

$output_wikipages = $library->getPages();

//setup file ----------------------------------------------------------------
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


if (isset($output_library['library_id'])) {
	//get bookmark
	$bookmark->item_id = $output_library['library_id'];
	$output_library['bookmark'] = $bookmark->getBookmark(1);
}

//RSP items
if (!empty($output_library['library_id'])) {
	$output_library['rsp'] = $rsp->selRspItem($output_library['library_id']);
}

if (!empty($output_library['group_id']) || isset($group_id)) {
	// are we allowed to publish to the public? If yes we give temporary public publish permission
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['rsp'], $c_acs['arr_acs']['privilege']['allow_rsp_public'])) { //resource_id, Priv_id
		$c_acs['resource_privilege'][$c_acs['arr_acs']['resource']['node']['rsp']][] = $c_acs['arr_acs']['privilege']['allow_rsp_public'];
	}
	
	// are we allowed to publish to the node? If yes we give temporary node publish permission
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['rsp'], $c_acs['arr_acs']['privilege']['allow_rsp_node'])) { //resource_id, Priv_id
		$c_acs['resource_privilege'][$c_acs['arr_acs']['resource']['node']['rsp']][] = $c_acs['arr_acs']['privilege']['allow_rsp_node'];
	}
}

//move vars to template ----------------------------------------------------
if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_wikipages)) {
	$body->set('wikipages', $output_wikipages);
}

if (!empty($output_filenames)) {
	$body->set('filenames', $output_filenames);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
