<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['group'], $c_acs['arr_acs']['privilege']['allow_create'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

//append language setup
require_once($languageTextPath . 'group_setup_rules.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');
require_once($languageArrayPath . 'arr_acs.lang.php');


if (isset($_POST['create_group'])) {
	$output_group = array();
	$output_group['group_visibility'] = $frmdata['group_visibility'];

	$display = "group_setup";
}
elseif (isset($_POST['insert_group'])) {
	if (empty($frmdata['group_title'])) {
	    $GLOBALS['am_error_log'][] = array(11, null, null);
	}
	
	if (empty($frmdata['group_synopsis'])) {
	    $GLOBALS['am_error_log'][] = array(30, null, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		//setup Acs
		$group_acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['group']);
	
		//append data
		if ($frmdata['group_visibility'] != 1) {//hidden group
		    $frmdata['group_rules'] = $lang['txt_group_hidden_rules'];
		}
		else {
			$frmdata['group_rules'] = $lang['txt_group_visible_rules'];
		}
		
		$output_profile = $user->selProfile(null, $me['user_id']);
		
		//setup group
		require_once('class/GroupAdmin.class.php');
		$group = new GroupAdmin($db, $me);
		$group->lang = $lang;
		$group->im = $im;
		$group->im->user_id = $me['user_id'];
		$group->c_acs = $c_acs;
		$group->default_acs_ids = $c_acs['arr_acs']['resource']['group'];
		$group->default_acs_role_id = $c_node['rsp']['group']['default'];
		$group->default_acs_admin_id = $c_acs['arr_acs']['group_administrator_role'];
		$group->default_acs_role_names = $lang['arr_acs']['group_role'];
		$group->group_file_allocation = $c_node['file']['default_max_group_space'];
		$group->acs = $group_acs;
		$group->status_ids = $c_node['group']['status'];
		$group->member_status_ids = $c_node['group']['member_status'];
		$group->setup = $c_node['group_setup'];
		$group->admin_message_text = readTxtFile($languageTextPath . "admin_group_create.txt.php");
		$group->data = $frmdata;
		$group->profile_id = $output_profile['profile_id'];
		$make_group = $group->createGroup();
		
		// add tags
		if (!empty($frmdata['tags'])) {
			require_once('class/Tag.class.php');
			$tag = new Tag($db, null);
			$tag->rsp_item_type_id = $c_node['rsp']['item_type']['group'];
			$tag->level_id = $c_node['tag']['level']['recommended'];
			$frmdata['group_id'] = $group->group_id;
			
			$tag->user_id = $me['user_id'];
			$tag->insertTags($frmdata);
		}
		
		
		if (isset($make_group) && $make_group == 1) {
		    $display = "completed_pending";
		}
		elseif (isset($make_group) && $make_group == 2) {
			$body->set('group_id', $group->group_id);
		    $display = "completed";
		}
		else {
			$display = "error";
		}
		
	}
	else { //formCheck failed
		$output_group = $frmdata;
		$display = "group_setup";
		
	}
	
}
else {
	$display = "group_select";
}


//move to template
if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

$body->set('group_registration_type', $c_node['group']['registration_type']);
$body->set('group_setup', $c_node['group_setup']);
$body->set('language_id', $me['language_id']);

include "inc/footer.inc.php";

?>
