<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// Tom Calthrop - 24th April 2004 (info@barnraiser.org)

// MODULE --------------------------------------------------------------
$c_acs['arr_section']['user'] = 							"1";
$c_acs['arr_section']['group'] = 							"2";


// SECTION ROLE ----------------------------------------------------------------
// roles are attached to sections
// array index refers to the section_id
// array values are the role_id's and are from language file (arr_acs.lang.php)
$c_acs['section_role'][1] = 								array(101,102); 			//user
$c_acs['section_role'][2] = 								array(201,202,203,204, 205);//group


// RESOURCES --------------------------------------------------------------------
// A list of resources available within the build
$c_acs['arr_acs']['resource']['administration'] = 			"101"; 				//user
$c_acs['arr_acs']['resource']['membership'] = 				"102"; 				//user
$c_acs['arr_acs']['resource']['social_network'] = 			"103"; 				//user
$c_acs['arr_acs']['resource']['acs'] = 						"104"; 				//user
$c_acs['arr_acs']['resource']['shoutbox'] = 				"105"; 				//user
$c_acs['arr_acs']['resource']['rsp'] = 						"106"; 				//user
$c_acs['arr_acs']['resource']['group'] = 					"107"; 				//user
$c_acs['arr_acs']['resource']['poll'] = 					"108"; 				//user
$c_acs['arr_acs']['resource']['forum'] = 					"109";				//user
$c_acs['arr_acs']['resource']['newsletter'] = 				"110";				//user
$c_acs['arr_acs']['resource']['group_administration'] = 	"201"; 				//group
$c_acs['arr_acs']['resource']['group_acs'] = 				"202"; 				//group
$c_acs['arr_acs']['resource']['group_membership'] = 		"203"; 				//group
$c_acs['arr_acs']['resource']['group_library'] = 			"204"; 				//group
$c_acs['arr_acs']['resource']['group_forum'] = 				"205"; 				//group
$c_acs['arr_acs']['resource']['group_files'] = 				"206"; 				//group
$c_acs['arr_acs']['resource']['group_schedule'] = 			"207"; 				//group
$c_acs['arr_acs']['resource']['group_rsp'] = 				"208"; 				//group
$c_acs['arr_acs']['resource']['group_poll'] = 				"209"; 				//group
$c_acs['arr_acs']['resource']['group_blog'] = 				"210"; 				//group
$c_acs['arr_acs']['resource']['group_newsletter'] = 		"211";				//group
$c_acs['arr_acs']['resource']['group_channels'] = 			"212";				//group


// SECTION RESOURCE ------------------------------------------------------------
// resources are attached to sections
// array index refers to the section_id
// array values are the recourse_id's and are from language file (arr_acs.lang.php)
$c_acs['section_resource'][1] = 							array(101,103,104,105,106,107,108,109,110); 					//user
$c_acs['section_resource'][2] = 							array(201,202,203,204,205,206,207,208,209,210,211,212);		//group

// RESOURCE PRIVILEGE CONFIGURATION
// privileges are attached to resources
// $c_acs['resource_privilege'][1] - '1' refers to the id of the language
// array ( $acs['arr_resource'][1])
// we store an array of privilege_id's which refer to the id of the privilege
// array ( $acs['arr_privilege'][1])
//
$c_acs['resource_privilege'][101] = 						array(1,8,9); 		//administration-user
$c_acs['resource_privilege'][102] = 						array(); 			//membership-user
$c_acs['resource_privilege'][103] = 						array(1); 			//social_network-user
$c_acs['resource_privilege'][104] = 						array(1); 			//acs-user
$c_acs['resource_privilege'][105] = 						array(1,2); 			//shoutbox-user
$c_acs['resource_privilege'][106] = 						array(3,5,11); 			//cms-user
$c_acs['resource_privilege'][107] = 						array(12); 			//acs-user
$c_acs['resource_privilege'][108] = 						array(13); 			//acs-poll
$c_acs['resource_privilege'][109] = 						array(13); 			//acs-forum
$c_acs['resource_privilege'][110] = 						array(14); 			//acs-newsletter

$c_acs['resource_privilege'][201] = 						array(1); 			//administration-group
$c_acs['resource_privilege'][202] = 						array(1); 			//acs-group
$c_acs['resource_privilege'][203] = 						array(1,3,4); 		//membership-group
$c_acs['resource_privilege'][204] = 						array(1,3,10); 		//library-group
$c_acs['resource_privilege'][205] = 						array(1,3,6,10,15); 	//forum-group
$c_acs['resource_privilege'][206] = 						array(1,3); 		//images-group
$c_acs['resource_privilege'][207] = 						array(1,3); 		//events-group
$c_acs['resource_privilege'][208] = 						array(5,7,3,11); 		//cms-group
$c_acs['resource_privilege'][209] = 						array(1,3,10); 		//poll-group
$c_acs['resource_privilege'][210] = 						array(1,3,10); 		//blog-group
$c_acs['resource_privilege'][211] = 						array(14); 			//newsletter-group
$c_acs['resource_privilege'][212] = 						array(1,3); 		//channel-group

// PRIVILEGES --------------------------------------------------------------------
// A list of privileges available within the build
$c_acs['arr_acs']['privilege']['allow_access'] = 			"1";
$c_acs['arr_acs']['privilege']['add_item'] = 				"2";
$c_acs['arr_acs']['privilege']['allow_edit'] = 				"3";
$c_acs['arr_acs']['privilege']['allow_invite'] = 			"4";
$c_acs['arr_acs']['privilege']['allow_rsp_public'] = 		"5";
$c_acs['arr_acs']['privilege']['allow_hidden'] = 			"6";
$c_acs['arr_acs']['privilege']['allow_rsp_group_home'] = 	"7";
$c_acs['arr_acs']['privilege']['allow_edit_group'] = 		"8";
$c_acs['arr_acs']['privilege']['allow_edit_user'] = 		"9";
$c_acs['arr_acs']['privilege']['allow_comment'] = 			"10";
$c_acs['arr_acs']['privilege']['allow_rsp_node'] = 			"11";
$c_acs['arr_acs']['privilege']['allow_create'] = 			"12";
$c_acs['arr_acs']['privilege']['allow_add'] = 				"13";
$c_acs['arr_acs']['privilege']['allow_send'] = 				"14";
$c_acs['arr_acs']['privilege']['allow_locking'] = 			"15";

// DEFAULTS --------------------------------------------------------------------
//what is the default role_id for a user at registration
$c_acs['arr_acs']['user_join_role_default'] = 				"102";
//what is the default role_id for the group administrator (used at group create)
$c_acs['arr_acs']['group_administrator_role'] = 			"201";
// what is the default role for a member joining a group at group create time?
$c_acs['arr_acs']['group_join_role_default'] = 				"205";


//RSS CONFIGURATION ------------------------------------------------------
// options: "RSS2.0" for RSS 2.0, "RSS1.0" for RSS 1.0, "RSS0.91" for 
// RSS 0.91, "PIE0.1" for PIE 0.1, "MBOX" for Unix mbox, "OPML" for OPML 
// 1.0, "ATOM0.3" for ATOM 0.3, "HTML" for HTML, "JAVASCRIPT" for Javascript
$c_node['rss']['output'] = 									"RSS2.0";

// END OF CONFIGURATION FILE ---------------------------------------------

?>
