<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


class Message {
	// CLASS FUNCTIONS
	// Message
	// setMessageId
	// setStatus
	// getStatus
	// setBoxes
	// getMessageBox
	// getMessage
	
	
	
	var $db;//get db connect
	var $message_id;// message id
	var $status;// message status
	var $boxes;// holding the coding of the boxes

	
	
	// Message --------------------------------------------------------------------
	// the constuctor
	// erik sundelof - 29th Nov 2004
	//
	function Message($db, $message_id=null) {
		$this->db         = $db;
		$this->message_id = $message_id;
	}//EO Message
	
	
	
	// setMessageId --------------------------------------------------------------------
	// erik sundelof - 29th Nov 2004
	//
	function setMessageId($message_id) {
		$this->message_id = $message_id;
	}//EO setMessageId
	
	
	
	// setStatus --------------------------------------------------------------------
	// Set message status
	// erik sundelof - 29th Nov 2004
	//
	function setStatus($status) {
		$query = "
			UPDATE " . $this->db->prefix . "_user_message
			SET message_status=". $status . " 
			WHERE 
			message_id=". $this->message_id
		;

		// Setting the user to online
		$this->db->Execute($query);
		$this->status = $status;
	}//EO setStatus

	
	
	// getStatus --------------------------------------------------------------------
	// get message status
	// erik sundelof - 29th Nov 2004
	//
	function getStatus() {
		return $this->status;
	}//EO getStatus
	
	
	
	// setBoxes --------------------------------------------------------------------
	// Set message box coding
	// erik sundelof - 29th Nov 2004
	//
	function setBoxes($inbox, $savebox, $outbox) {
		$this->boxes["in_box"]     = $inbox;
		$this->boxes["save_box"]   = $savebox;
		$this->boxes["out_box"]    = $outbox;
	}//EO setBoxes
	
	
	
	// getMessageBox --------------------------------------------------------------------
	// Get the name of the box
	// erik sundelof - 29th Nov 2004
	//
	function getMessageBox($message_box) {

		if ($message_box == $this->boxes['out_box']) {
			$boxname = "out_box";
		}
		else if ($message_box == $this->boxes['save_box']) {
			$boxname = "save_box";

		}
		else if ($message_box == $this->boxes['in_box']) {
			$boxname = "in_box";
		}

		return $boxname;
	}//EO getMessageBox
	
	
	
	// getMessage --------------------------------------------------------------------
	// Setting the status of the message to read
	// erik sundelof - 29th Nov 2004
	//
	function getMessage() {
		// Getting the box id
		$query = "SELECT m.message_box FROM " . $this->db->prefix . "_user_message m
				WHERE m.message_id = " . $this->message_id;

		$result = $this->db->Execute($query);
		$message_box = $result->fields["message_box"];
		
		unset($result);
		
		if (!empty($message_box)) {
			// Selection of messages is differs for different boxes...
			if ($message_box == $this->boxes['out_box']) {
				$join = "m.to_user_id=p.user_id";
				$verify = "m.from_user_id=" . $this->user_id;
			}
			else if ($message_box == $this->boxes['save_box']) {
				$join = "m.owner_user_id=p.user_id";
				$verify = "m.owner_user_id=" . $this->user_id;
	
			}
			else if ($message_box == $this->boxes['in_box']) {
				$join = "m.from_user_id=p.user_id";
				$verify = "m.to_user_id=" . $this->user_id;
			}
	
			// Forming query and selecting the messages with the correct owner id:s...
			// The \" m.to_user_id, m.owner_user_id, m.from_user_id \" are there so that one can track
			// everything about the users linked to that particular message outside the class.
	
			//verify stops you putting someone elses message_id in on the location bar of browser.
			$query = "
				SELECT p.profile_nic, p.file_id, m.message_id,
				m.owner_user_id, m.to_user_id, m.from_user_id, m.message_type, m.message_box,
				m.message_status, m.message_subject, m.message_body, m.message_create_datetime
				FROM " . $this->db->prefix . "_user_message m
				LEFT JOIN " . $this->db->prefix . "_user_profile p on ". $join ." and p.profile_default=1 
				WHERE 
				m.message_id = " . $this->message_id . " AND " . 
				$verify;
			;
			
			$result = $this->db->Execute($query);
		
			if (isset($result->fields)) {
				$output_message = $result->fields;
				$result->Close();
				
				return $output_message;
			}
			else {
				$error_info = "function=getMessage class=Message.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO getMessage
}
?>
