<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";
include $c_node['dir']['aroundme'] . "config/config_acs.inc.php";


if (isset($_REQUEST['http_referer'])) {
    $http_referer = $_REQUEST['http_referer'];
}
else {
	$http_referer = getenv("HTTP_REFERER");
}


//set up user
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);
$user->status_ids = $c_node['user']['status'];

//if the session is timed out we destroy it
if(isset($_SESSION['s_user_id'])) {
	session_unset();
	session_destroy();

	session_start();
	$_SESSION['s_language_id'] = $language_id;
}


//form actions
if (isset($_POST['login'])) {

	if (isset($_POST['email']) && $_POST['email'] && isset($_POST['password']) && $_POST['password']) {
		$user->relation_type = $c_node['user']['relation_type']['approved'];
		$user->aroundme_dir = $c_node['dir']['aroundme'];
		
		
		require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, 1, null);
		$user->statistic = $statistic;
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];
		
		$user->checkLogin($_REQUEST['email'],$_REQUEST['password']);

		if (empty($GLOBALS['am_error_log'])) {
			//setup social network
			require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'SocialNetwork.class.php');
			$sn = new SocialNetwork(null, $db, $c_node['node']['node_id'], $c_node['sn']['max_degree']);
			$sn->relation_type_ids = $c_node['user']['relation_type'];
			$sn->status_ids = $c_node['user']['status'];
			$user->sn = $sn;
			$user->http_referer = $http_referer;
			$user->loginUser($_REQUEST['email'],$_REQUEST['password'], $c_node['node']['node_id']);
			
		}
	}
	else {
		$GLOBALS['am_error_log'][] = array(20, null, null);
	}

}
elseif (isset($_REQUEST['registration_complete'])) {
	$display = "registration_complete";
}

//CONTENT
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Cms.class.php');
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'File.class.php');


//setup file
$file = new File($db, $c_acs['arr_section']['user'], $c_node['file'], $c_node['dir']);
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


//setup cms
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Cms.class.php');
$cms = new Cms($db, null);
$cms->level_id = $c_node['cms']['cms_level']['public'];
$cms->cms_status_id = $c_node['cms']['status']['live'];
$cms->language_id = $_SESSION['s_language_id'];


//get blog ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_blog'];
$output_g_cms_blogs = $cms->getCmsItems();
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_blog'];
$output_u_cms_blogs = $cms->getCmsItems();
$output_cms_blogs = array_merge($output_g_cms_blogs, $output_u_cms_blogs);

foreach($output_cms_blogs as $key => $i):
	$cms_blog_ids[] = $i['item_id'];
endforeach;

//setup blog
$blog = new Blog($db, null, $date, $file);
//get blog items
if (!empty($cms_blog_ids)) {
	$blog->blog_ids = $cms_blog_ids;
	$output_blogs = $blog->getBlogs();
}


//get group poll ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
$output_cms_polls = $cms->getCmsItems();

foreach($output_cms_polls as $key => $i):
	$cms_poll_ids[] = $i['item_id'];
endforeach;

// poll setup
$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->order_by = "poll_start_datetime desc";
//get polls
if (!empty($cms_poll_ids)) {
	$poll->poll_ids = $cms_poll_ids;
	$output_polls = $poll->getPolls();
}
	

//get library ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
$output_g_cms_library_items = $cms->getCmsItems();
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_library'];
$output_u_cms_library_items = $cms->getCmsItems();
$output_cms_library_items = array_merge($output_g_cms_library_items, $output_u_cms_library_items);

foreach($output_cms_library_items as $key => $i):
	$cms_library_item_ids[] = $i['item_id'];
endforeach;

//library setup
$library = new Library($db, null, $date, $file);
//get library items
if (!empty($cms_library_item_ids)) {
	$library->library_item_ids = $cms_library_item_ids;
	$output_library_items = $library->getLibraryItems();
}






//TEMPLATE
if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
	$body->set('cms_blogs', $output_cms_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
	$body->set('cms_subjects', $output_cms_subjects);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
	$body->set('cms_polls', $output_cms_polls);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
	$body->set('cms_library_items', $output_cms_library_items);
}

$body->set('arounmdetemplatePath', $c_node['dir']['aroundme'] . $templatePath . $c_node['node']['template_default_name'] . "/");

$body->set('language_available', $c_node['node']['language_available']);

$body->set('http_referer', $http_referer);



if (isset($display)) {
	$body->set('display', $display);
}

$pagename = "index";
include "inc/footer.inc.php";
?>
