<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

//ACS check

if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_poll'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}

require_once($c_node['dir']['class_path'] . 'Poll.class.php');


$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->section_item_id = $group_id;
$poll->user_id = $user_id;


if (isset($_REQUEST['poll_id'])) {
	$poll_id = $_REQUEST['poll_id'];
	$poll->poll_id = $poll_id;
}


if (isset($_POST['insert_poll'])) {
	if (!empty($data['cms_public'])) {
		$data['level_id'] = $c_node['cms']['cms_level']['public'];
	}
	elseif (!empty($data['cms_node'])) {
		$data['level_id'] = $c_node['cms']['cms_level']['node'];
	}
	elseif (!empty($data['cms_group'])) {
		$data['level_id'] = $c_node['cms']['cms_level']['group'];
	}
	else {
		$data['level_id'] = null;
	}
	
	$poll->insertPoll($data);
	
	if (empty($GLOBALS['am_error_log'])) {
			//setup cms
			require_once($c_node['dir']['class_path'] . 'Cms.class.php');
			$cms = new Cms($db, $c_acs['arr_section']['group']);
			$cms->section_item_id = $group_id;
			$cms->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
			$cms->user_id = $user_id;
			$temp['language_id'] = $output_group['language_id'];
			$temp['genre_id'] = $output_group['genre_id'];
			$temp['item_id'] = $poll->poll_id;
			
			//insert node cms entry
		  	if($c_node['cms']['node']['auto_publish'] == 1) {
				$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
				
			if (isset($data['cms_node'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['node'];
				$cms->insertCmsItem($temp);
			}
			
			if (isset($data['cms_public'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['public'];
				$cms->insertCmsItem($temp);
			}
			
			//insert group cms entry
			if (isset($data['cms_group'])) {
			    $temp['level_id'] = $c_node['cms']['cms_level']['group']['home'];
				$cms->insertCmsItem($temp);
			}
			
			//setup statistics
			require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
			$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
			
			//update stats - total group polls
			$statistic->section_item_id = $group_id;
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_polls'];
			$statistic->setStatistic($poll->getPollCount());
			
			//update stats - total group member polls
			$statistic->section_item_id = $group_id;
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_polls'];
			$poll->user_id = $me['user_id'];
			$statistic->user_id = $me['user_id'];
			$statistic->setStatistic($poll->getPollCount());
			
			
			
			return header("Location: g_poll_edit.php?group_id=". $group_id . "&poll_id=" . $poll->poll_id . "&" . SID);
			exit;
		}
		else {
			$output_poll = $data;

			$display = "add_poll";
		}
	
}
elseif (isset($_POST['update_poll'])) {
	$poll->updatePoll($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: g_poll.php?group_id=". $group_id . "&poll_id=" . $poll_id . "&view_poll=1&" . SID);
		exit;
	}
	else {
		$output_poll = $data;
		$display = "edit_poll";
	}

}
elseif (isset($_POST['delete_poll'])) {
	$poll->deletePoll();
	return header("Location: g_poll.php?group_id=". $group_id . "&" . SID);
	exit;

}
elseif (isset($_POST['insert_poll_option'])) {
	$poll->insertOption($data['option_body']);
	return header("Location: g_poll_edit.php?group_id=". $group_id . "&poll_id=" . $poll_id . "&view_poll=1&" . SID);
	exit;
}
elseif (isset($_POST['update_poll_option'])) {
	$poll->updateOption($data['option_id'], $data['option_body']);
	return header("Location: g_poll_edit.php?group_id=". $group_id . "&poll_id=" . $poll_id . "&view_poll=1&" . SID);
	exit;

}
elseif (isset($_POST['delete_poll_option'])) {
	$poll->deleteOption($data['option_id']);
	return header("Location: g_poll_edit.php?group_id=". $group_id . "&poll_id=" . $poll_id . "&view_poll=1&" . SID);
	exit;

}
elseif (isset($poll_id)) {
	$output_poll = $poll->getPoll();
	$display = "edit_poll";

}
else {
	$display = "add_poll";
}


if (isset($poll_id)) {

	//You can delete before any comments are added or votes are given
	$output_poll_usage = $poll->getUserPollParticipation();
	
	if (isset($_REQUEST['option_id'])) { //we edit an option
		$output_option = $_REQUEST['option_id'];
	}

	if (isset($output_poll)) {
		$output_poll_history = $poll->pollUserVoteHistory($me['user_id']);
	}
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_polls)) {
   $body->set('polls', $output_polls);
}

if (!empty($output_poll)) {
   $body->set('poll', $output_poll);
}

if (!empty($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

if (!empty($output_option)) {
   $body->set('option', $output_option);
}

if (!empty($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

if (!empty($output_poll['poll_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown($output_poll['poll_start_datetime'], 1, 'start'));
}
else {
	$tomorrow = date("Y-m-d 00:00:00", mktime()+(24*60*60));
	$body->set('start_datedropdown', $date->dateDropdown($tomorrow, 1, 'start', 0, 5));
}

if (!empty($output_poll['poll_end_datetime'])) {
   $body->set('end_datedropdown', $date->dateDropdown($output_poll['poll_end_datetime'], 1, 'end', 0, 5));
}
else { 
	$tomorrow_plus_seven = date("Y-m-d 00:00:00", mktime()+(24*7*60*60));
	$body->set('end_datedropdown', $date->dateDropdown($tomorrow_plus_seven, 1, 'end', 0, 5));
}

$body->set('cms_node_auto_publish', $c_node['cms']['node']['auto_publish']);

include "inc/footer.inc.php";

?>
