<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// Tom Calthrop (info@barnraiser.org)



//DATABASE CONFIGURATION --------------------------------------------------
$c_node['db']['driver'] = 											"mysql";
$c_node['db']['host'] = 											"localhost";
$c_node['db']['user'] = 											"your_db_name";
$c_node['db']['pass'] = 											"your_db_password";
$c_node['db']['db']=	 											"your_db_name";
$c_node['db']['prefix'] =	 										"am";


// MAIL CONFIGURATION ----- ----------------------------------------------
// phpMailer. See http://phpmailer.sourceforge.net/ for settings.
$c_node['mail']['host'] = 											"your_mail_server.com";
$c_node['mail']['no_reply_address'] = 								"nopreply@your_mail.org";
$c_node['mail']['default_address'] = 								"you@your_mail.org";
$c_node['mail']['mailer'] = 										"smtp";
$c_node['mail']['from_name'] = 										"company_name";
$c_node['mail']['wordwrap'] = 										"80";
$c_node['mail']['language'] = 										"en";


// PHP CONFIGURATION -----------------------------------------------------
ini_set('error_reporting', E_ALL); 								// error handling in development environment.
//ini_set('error_reporting', 0); 										// error handling in production environment
ini_set('arg_separator.output', 'amp;');							//string (needed for XHTML support


// DIRECTORY CONFIGURATION --------------------------------------------------
// local path to assets directory-"/public_html/asset/"
$c_node['dir']['asset_path'] = 										"../../asset/";
// path to the templates directory
$c_node['dir']['template_path'] = 									"template/";
// path to the class directory
$c_node['dir']['class_path'] = 										"class/";
// aroundme www directory path
$c_node['dir']['aroundme_www_path'] = 								"/aroundme_0_4_3/";



// NODE CONFIGURATION ----------------------------------------------------
$c_node['node']['node_id'] = 										"1"; // always set to 1 as multinoding is not supported yet
$c_node['node']['template_default_name'] = 							"am_default";
$c_node['node']['template_default_id'] = 							"1";
//debug mode - set to 1 to see database error etc, null just returns user errors
$c_node['node']['debug_mode'] = 									"1";
// list within the array the language ID's available to this node.check
// you have the language files installed before extending this.
$c_node['node']['language_default'] = 								"1"; //English, the default node language
$c_node['node']['language_available'] = 							array(1); //English only
// setup the help group id's for each language.
$c_node['node']['help_group_id'][1] =								"1"; //English default help group
// do you want users to be able to register for this node? (0=off, 1=on)
$c_node['node']['allow_registration'] = 							"1";
// do you want users to be able to invite others when they register? (0=off, 1=on)
$c_node['node']['allow_setup_invites'] = 							"1";
// do you want users to be able to retrieve a new password for this node? (0=off, 1=on)
$c_node['node']['allow_new_password'] = 							"1";
//default home page (inserted in DB upon registration
$c_node['node']['page_default'] = 									"welcome.php";


// FILE CONFIGURATION ----------------------------------------------------
$c_node['file']['default_max_user_space'] = 						"5000";
$c_node['file']['default_max_group_space'] = 						"5000";



// MIME CONFIGURATION ----------------------------------------------------
//full list at http://www.phpfreaks.com/mimetypes.php
//make sure you think about the implications for viruses before editing this
//edit the functions.inc.php formatFileOuptput functions to create correct html output
$c_node['file']['mime'][1]['mime'] = 								"image/jpeg";
$c_node['file']['mime'][1]['suffix'] = 								"jpg";
$c_node['file']['mime'][2]['mime'] = 								"image/png";
$c_node['file']['mime'][2]['suffix'] = 								"png";
$c_node['file']['mime'][3]['mime'] = 								"image/gif";
$c_node['file']['mime'][3]['suffix'] = 								"gif";
$c_node['file']['mime'][4]['mime'] = 								"application/pdf";
$c_node['file']['mime'][4]['suffix'] = 								"pdf";
$c_node['file']['mime'][5]['mime'] = 								"text/plain";
$c_node['file']['mime'][5]['suffix'] = 								"txt";
$c_node['file']['mime'][6]['mime'] = 								"application/x-shockwave-flash";
$c_node['file']['mime'][6]['suffix'] = 								"swf";
//image and thumbs
$c_node['file']['image']['max_width'] = 							"278"; //main image
$c_node['file']['image']['thumb_directory'] = 						"thumbs/";
$c_node['file']['image']['thumb'][1]['name'] =						"t1";
$c_node['file']['image']['thumb'][1]['noimage'] =					"no_file_t1.png";
$c_node['file']['image']['thumb'][1]['width'] =						"158";
$c_node['file']['image']['thumb'][2]['name'] =						"t2";
$c_node['file']['image']['thumb'][2]['width'] =						"80";
$c_node['file']['image']['thumb'][2]['noimage'] =					"no_file_t2.png";
$c_node['file']['image']['thumb'][3]['name'] =						"t3";
$c_node['file']['image']['thumb'][3]['width'] =						"32";
$c_node['file']['image']['thumb'][3]['noimage'] =					"no_file_t3.png";
//name of "broken image" image is displayed if the file cannot be found
$c_node['file']['image']['broken_image'] =							"broken_image.png";

//sometimes MIME types vary from browser to browser - this array will convert
//other MIME types to those listed above
// add an array for each instance of the MIME types you want changing
$c_node['file']['mime']['browser_path'] =							array(array("from" => "image/pjpeg", "to" => "image/jpeg"));

// MESSAGING CONFIGURATION ----------------------------------------------
$c_node['messaging']['message_box_max_size'] = 						"10000";
$c_node['messaging']['message_in_box'] = 							"1";
$c_node['messaging']['message_out_box'] = 							"2";
$c_node['messaging']['message_save_box'] = 							"3";
$c_node['messaging']['message_status_unread'] = 					"1";
$c_node['messaging']['message_status_read'] = 						"2";



// CMS CONFIGURATION ----------------------------------------------------

// group default (if auto register they get this level by default
$c_node['cms']['group']['default'] = 								"12";
// zero = needs editorial approval, 1 = auto publish to splash
$c_node['cms']['node']['auto_publish'] = 							"0";
// content types (you will still need to edit DB queries in cms class if appending this)
$c_node['cms']['item_type']['user_blog'] = 							"1";
$c_node['cms']['item_type']['group_blog'] = 						"2";
$c_node['cms']['item_type']['user_library'] = 						"3";
$c_node['cms']['item_type']['group_library'] = 						"4";
$c_node['cms']['item_type']['user_files'] = 						"5";
$c_node['cms']['item_type']['group_files'] = 						"6";
$c_node['cms']['item_type']['user_activity'] = 						"7";
$c_node['cms']['item_type']['group_activity'] = 					"8";
$c_node['cms']['item_type']['group_forum_subject'] = 				"9";
$c_node['cms']['item_type']['user_poll'] = 							"10";
$c_node['cms']['item_type']['group_poll'] = 						"11";
$c_node['cms']['item_type']['user_task'] = 							"12";
$c_node['cms']['item_type']['group_task'] = 						"13";
// cms content status's
$c_node['cms']['status']['live'] = 									"3";
$c_node['cms']['status']['hold'] = 									"2";
$c_node['cms']['status']['pending'] = 								"1";
// number of days to display content historically (increase on less busy installs)
$c_node['cms']['publishing']['most_read'] = 						"14";
//Abuse report default level ID from an unallocated abuse report
$c_node['cms']['abuse_status']['unallocated'] = 					"2";
//we have a cms for both the node and the group (home page)
$c_node['cms']['cms_level']['public'] = 							"64";
$c_node['cms']['cms_level']['node'] = 								"32";
$c_node['cms']['cms_level']['group']['home'] = 						"4";
// user levels - we only publish to 4 degrees -
// above that is regarded as for everyone - see social network section


// USER CONFIGURATION --------------------------------------------------
$c_node['statistic']['user']['total_logins'] = 						"1";
$c_node['statistic']['user']['total_blogs'] = 						"4";
$c_node['statistic']['user']['total_shouts'] = 						"5";
$c_node['statistic']['user']['total_guestbooks'] = 					"6";
$c_node['statistic']['user']['total_library_items'] = 				"7";
$c_node['statistic']['user']['total_forum_subjects'] = 				"8";
$c_node['statistic']['user']['total_comments'] = 					"9";
$c_node['statistic']['group']['total_members'] = 					"10";
$c_node['statistic']['group']['total_forum_subjects'] = 			"11";
$c_node['statistic']['group']['total_comments'] = 					"12";
$c_node['statistic']['group']['total_library_items'] = 				"13";
$c_node['statistic']['group']['total_polls'] = 						"14";
$c_node['statistic']['group_member']['total_blogs'] = 				"15";
$c_node['statistic']['group_member']['total_comments'] = 			"16";
$c_node['statistic']['group_member']['total_forum_subjects'] = 		"17";
$c_node['statistic']['group_member']['total_library_items'] = 		"18";
$c_node['statistic']['group_member']['total_polls'] = 				"19";


// USER CONFIGURATION --------------------------------------------------
// relationship type
$c_node['user']['relation_type']['approved'] = 						"2";
$c_node['user']['relation_type']['approval_pending'] = 				"1";
// user status (pending means they have registered by not setup)
$c_node['user']['status']['inactive'] = 							"1";
$c_node['user']['status']['hold'] = 								"2";
$c_node['user']['status']['pending'] = 								"3";
$c_node['user']['status']['active'] = 								"4";



// GROUP CONFIGURATION --------------------------------------------------
// member statistics
// registration types
$c_node['group']['registration_type']['automatic'] = 				"1";
$c_node['group']['registration_type']['approved'] = 				"2";
$c_node['group']['registration_type']['closed'] = 					"3";
// member status
$c_node['group']['member_status']['barred'] = 						"1";
$c_node['group']['member_status']['pending'] = 						"2";
$c_node['group']['member_status']['active'] = 						"3";
// group status
$c_node['group']['status']['inactive'] = 							"1";
$c_node['group']['status']['hold'] = 								"2";
$c_node['group']['status']['pending'] = 							"3";
$c_node['group']['status']['active'] = 								"4";
// if you allow auto approval anyone can set up a group in this node
// without your permission. If you do not, anyone with the "group admin"
// ACS permission will receive a message asking them to review the application
// allow = "1" / deny = "0"
$c_node['group_setup']['allow_auto_visible_approval'] = 			"1";
$c_node['group_setup']['allow_auto_hidden_approval'] = 				"1";



// ACTIVITY CONFIGURATION ---------------------------------------------------
$c_node['activity']['task_user_status']['pending'] = 				"1";
$c_node['activity']['task_user_status']['confirmed'] = 				"2";
$c_node['activity']['task_user_status']['rejected'] = 				"3";
$c_node['activity']['task_user_status']['withdrawn'] = 				"4";

$c_node['activity']['frequency']['no_repeat'] = 					"0";
$c_node['activity']['frequency']['daily'] = 						"1";
$c_node['activity']['frequency']['weekly'] = 						"3";
$c_node['activity']['frequency']['monthly'] = 						"9";
$c_node['activity']['frequency']['yearly'] = 						"12";



// BOOKMARK CONFIGURATION ---------------------------------------------------
$c_node['bookmark']['type']['watch'] = 								"1";
$c_node['bookmark']['type']['recommend'] = 							"2";


// SOCIAL NETWORK CONFIGURATION ---------------------------------------------------
$c_node['sn']['degree']['one'] = 									"1"; // friends (default)
$c_node['sn']['degree']['two'] = 									"2";  // two degrees
$c_node['sn']['degree']['three'] = 									"3";  // three degrees
$c_node['sn']['degree']['four'] = 									"4";  // four degrees

$c_node['sn']['max_degree'] = 										"4";  // four degrees

// END OF FILE ----------------------------------------------------------
?>
