<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

//Note setlocale(); is set in the User.class.php at login
//this will affect date output.

class Schedule {
	// CLASS FUNCTIONS
	// Schedule
	// setScheduleBase
	// getMax
	// getSchedule
	// getToDo
	// modifyActivityDate
	// populateActivity
	// calculateDate
	
	
	
	
	var $id;             // Group or user id
	var $db;             // Database connection
	var $tables;         // Head table to use
	var $schedule;       // The array that contains everything in the calendar
	var $todo;           // The array with non-time-specific activities
	var $daysinmonth;    // Number of days in month
	var $mh, $da, $yr;
	
	
	
	// Schedule --------------------------------------------------------------------
	// the constuctor
	// Erik Sundelf, 3rd June 2004
	//
	function Schedule($db, $now, $id = null, $type = null) {
		$this->db = $db;
		$this->id  = $id;
		
		$this->mh  = $now['mon'];
		$this->da  = $now['mday'];
		$this->yr  = $now['year'];

		$this->schedule = array(); // Initialize calendar
		$this->todo = array(); // Initialize calendar

	}//EO Schedule
	
	
	
	// setScheduleBase --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function setScheduleBase() {
		//setup calendar array
		$this->daysinmonth = date("t",mktime(0, 0, 0, $this->mh, 1, $this->yr));

		//populate the calendar array with dates
		//fill the calendar
		for ($i=0; $i < 24; $i++) {
			$temp = array(
				'today' => date("h:00",mktime($i,0,0,$this->mh,$this->da,$this->yr)),
				'hour' => $i,
				'content' => array()
			);

			array_push($this->schedule, $temp);
		}
	}//EO setScheduleBase
	
	
	
	// getMax --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function getMax() {
		$value = 0;
		for ($i=0; $i < 24; $i++) {
			$value = count($this->schedule[$i]['content'])>$value ? count($this->schedule[$i]['content']) : $value;
		}

		return $value;
	}//EO getMax
	
	
	
	// getSchedule --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function getSchedule() {
		return $this->schedule;
	}//EO getSchedule
	
	
	
	// getToDo --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function getToDo() {
		return $this->todo;
	}//EO getToDo
	
	
	
	
	// modifyActivityDate --------------------------------------------------------------------
	// Recalculate the dates so that the matches up the structure of the populating algortihm
	// Erik Sundelf, 3rd June 2004
	//
	function modifyActivityDate($activity) {

		$activity_date = $this->calculateDate($activity);
		
		if(!empty($activity_date[0])) {
			//$activity[5] = $activity_date[0];
			$activity["activity_start_datetime"] = $activity_date[0];
		}

		if(!empty($activity_date[1])) {
			//$activity[6] = $activity_date[1];
			$activity["activity_end_datetime"] = $activity_date[1];
		}

		return $activity;
	}//EO modifyActivityDate
	
	
	
	// populateActivity --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function populateActivity($activity) {
		if(!empty($activity['activity_start_datetime'])) {
			$start = strtotime($activity['activity_start_datetime']);
		}
		else {
			$start = 0;
		}
		
		if(!empty($activity['activity_end_datetime'])) {
			$end = strtotime($activity['activity_end_datetime']);
		}
		else {
			$end = 0;
		}

		// Defines useful dates
		$time_start      = mktime(0, 0, 1, $this->mh, $this->da, $this->yr);
		$time_end        = mktime(23, 59, 59, $this->mh, $this->da, $this->yr);
		
		if($start>=$time_start & $start<=$time_end) {
			if($end<=$time_end) {
				$hs = date("G", $start);
				$he = date("G", $end);
			}
			else {
				$hs = date("G", $start);
				$he = 23;
			}
			
			//echo $he . "<br>";
		}
		elseif($end>=$time_start & $end<=$time_end) {
			$hs = 0;
			$he = date("G", $end);
		}
		elseif($start<$time_start & $end>$time_end) {
			if(!empty($activity["activity_frequency"])) {
				if(!empty($activity["activity_start_hour"]) & !empty($activity["activity_end_hour"])) {
					$hs = $activity["activity_start_hour"];
					$he = $activity["activity_end_hour"]-1;
					if($he<$hs)
						$he = $hs;
				}
				else {
					$he = $hs = 1;
				}
			}
		}
		

		if(!empty($activity["activity_frequency"]) & empty($activity["activity_start_hour"]) & empty($activity["activity_end_hour"])) {
			$hs = $he = 1;
		}

		// Corrects hours if incorrect
		if(isset($hs)) {
			if($hs<0) {
				$hs = 0;
			}
		}

		// Corrects hours if incorrect
		if(isset($he)) {
			if($he>23) {
				$he = 23;
			}
		}

		if(isset($hs) & isset($he)) {

			for($h = $hs; $h < $he+1; $h++) {
				if(isset($activity["activity_frequency"])) {

					if($activity["activity_frequency"]==3){ // Weekly

						$weekday        = date("w", mktime(0, 1, 1, $this->mh, $this->da, $this->yr))+1;
						$start_weekday  = $activity["activity_start_weekday"];

						if(empty($activity["activity_end_weekday"]))
							$end_weekday = $activity["activity_start_weekday"];
						else
							$end_weekday = $activity["activity_end_weekday"];

						if($start_weekday<=$weekday & $end_weekday>=$weekday) {
							if(!empty($activity["activity_start_hour"]) & !empty($activity["activity_end_hour"]))
								array_push($this->schedule[$h]['content'], $activity);
							else
								array_push($this->todo, $activity);
						}
					}
					elseif ($activity["activity_frequency"]==9) { // Monthly
						$start_day = $activity["activity_start_day"];

						if(empty($activity["activity_end_day"]))
							$end_day = $activity["activity_start_day"];
						else
							$end_day = $activity["activity_end_day"];

						if($start_day<=$this->da & $end_day>=$this->da) {
							if(empty($activity["activity_start_hour"]) & empty($activity["activity_end_hour"]))
								array_push($this->todo, $activity);
							else
								array_push($this->schedule[$h]['content'], $activity);
						}
					}
					elseif ($activity["activity_frequency"]==10) { // Yearly
						$start_day = $activity["activity_start_day"];

						if(empty($activity["activity_end_day"]))
							$end_day = $activity["activity_start_day"];
						else
							$end_day = $activity["activity_end_day"];

						if($start_day<=$this->da & $end_day>=$this->da & $activity["activity_start_month"]<=$this->mh & $activity["activity_end_month"]>=$this->mh) {
							if(empty($activity["activity_start_hour"]) & empty($activity["activity_end_hour"]))
								array_push($this->todo, $activity);
							else
								array_push($this->schedule[$h]['content'], $activity);
						}
					}
					else {
						if(empty($activity["activity_start_hour"]) & empty($activity["activity_end_hour"]))
							array_push($this->todo, $activity);
						else
							array_push($this->schedule[$h]['content'], $activity);
					}
				}
				else
					array_push($this->schedule[$h]['content'], $activity);
			}
		}
	}//EO populateActivity
	
	
	
	// calculateDate --------------------------------------------------------------------
	// Calculate starting date
	// Erik Sundelf, 3rd June 2004
	//
	function calculateDate($activity){

		$sec[0] = (!empty($activity['activity_start_sec'])) ? $activity['activity_start_sec'] : "01";
		$min[0] = (!empty($activity['activity_start_min'])) ? $activity['activity_start_min'] : "01";
		$hour[0] = (!empty($activity['activity_start_hour'])) ? $activity['activity_start_hour'] : "01";
		$day[0] = (!empty($activity['activity_start_day'])) ? $activity['activity_start_day'] : 1;
		$month[0] = (!empty($activity['activity_start_month'])) ? $activity['activity_start_month'] : $this->mh;
		$year[0] = (!empty($activity['activity_start_year'])) ? $activity['activity_start_year'] : $this->yr;

		$sec[1] = (!empty($activity['activity_end_sec'])) ? $activity['activity_end_sec'] : "01";
		$min[1] = (!empty($activity['activity_end_min'])) ? $activity['activity_end_min'] : "01";
		$hour[1] = (!empty($activity['activity_end_hour'])) ? $activity['activity_end_hour']-1 : "01";
		$day[1] = (!empty($activity['activity_end_day'])) ? $activity['activity_end_day'] : $this->daysinmonth;
		$month[1] = (!empty($activity['activity_end_month'])) ? $activity['activity_end_month'] : $this->mh;
		$year[1] = (!empty($activity['activity_end_year'])) ? $activity['activity_end_year'] : $this->yr;

		if($hour[0]>$hour[1])
			$hour[1] = $hour[0];

		for($i = 0; $i<=1; $i++)
			$activity_date[$i] = mktime($hour[$i], $min[$i], $sec[$i], $month[$i], $day[$i], $year[$i]);
			//$activity_date[$i] = strtotime($year[$i]."-".$month[$i]."-".$day[$i]." ".$hour[$i].":".$min[$i].":".$sec[$i]);

		// Redefining the end date so that it matches the activities
		if(isset($activity["activity_frequency"]) && $activity["activity_frequency"]>0) {

			$freq = $activity["activity_frequency"];
			if($freq==3 | $freq==1) {
				$activity_date[0] = mktime(0, 0, 0, $this->mh, 1, $this->yr);
				$activity_date[1] = strtotime("+1 month -1 day", $activity_date[0]);
			}
		}

		if(!empty($activity["activity_start_datetime"])) {
			$activity_date[0] = ($activity_date[0]>=strtotime($activity["activity_start_datetime"])) ? $activity_date[0] : strtotime($activity["activity_start_datetime"]);
		}
		
		if(!empty($activity["activity_end_datetime"])) {
			$activity_date[1] = ($activity_date[1]>=strtotime($activity["activity_end_datetime"])) ? $activity_date[1] : strtotime($activity["activity_end_datetime"]);
		}
		
		$activity_date[0] = ($activity_date[0]<=mktime(0, 0, 0, $this->mh, 1, $this->yr)) ? date("Y-n-j G:i:s", mktime(0, 0, 0, $this->mh, 1, $this->yr)) : date("Y-n-j G:i:s", $activity_date[0]);
		$activity_date[1] = ($activity_date[1]<=mktime(0, 0, 0, $this->mh, $this->daysinmonth, $this->yr)) ? date("Y-n-j G:i:s", mktime(0, 0, 0, $this->mh, $this->daysinmonth, $this->yr)) : date("Y-n-j G:i:s", $activity_date[1]);

		if(empty($activity["activity_frequency"])) {
			$activity_date[0] = $activity['activity_start_datetime'];
			$activity_date[1] = $activity['activity_end_datetime'];
		}

		return $activity_date;
	}//EO calculateDate
}
