<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}


if (isset($_REQUEST['subject_id'])) {
	$subject_id = $_REQUEST['subject_id'];
}
else {
	header("Location: g_forum.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
	exit;
}


require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


//setup comment
$comment = new Comment($db, $c_node['cms']['item_type']['group_forum_subject'], $date);
$comment->section_item_id = $group_id;
$comment->user_id = $user_id;
$comment->item_id = $subject_id;


//setup forum
$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);
$forum->section_item_id = $group_id;
$forum->subject_id = $subject_id;



//process requests
if (isset($_POST['preview'])) {
	$output_comment = $data;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['display_comment_body'] = nl2br(htmlspecialchars($output_comment["comment_body"], ENT_QUOTES));
	$output_comment['comment_body'] = str_replace ('"', '&quot;', $output_comment['comment_body']);
	
	$display = "preview_section";

}
elseif (isset($_POST['insert'])) {
	
	$comment->insertComment($data);
		
	if (empty($GLOBALS['am_error_log'])) {
		//update user stats
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
		$statistic->section_item_id = $group_id;
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
		$statistic->setStatistic($comment->getCommentCount());
		
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$statistic->section_id = $c_acs['arr_section']['user'];
		$group->user_id = $user_id;
		$statistic->setStatistic($comment->getCommentCount());
		
		//goto the subject
		return header("Location: g_forum_subject.php?group_id=". $group_id . "&subject_id=". $subject_id . "&" . SID);
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $data;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}
elseif (isset($_POST['update_subject'])) {
	$forum->updateSubject($data);
	return header("Location: g_forum_subject.php?group_id=". $group_id . "&subject_id=". $subject_id . "&" . SID);
	exit;
}
elseif (isset($_POST['delete_subject'])) {
	$forum->deleteSubject($subject_id);
	return header("Location: g_forum.php?group_id=". $group_id . "&" . SID);
	exit;
}




//get subject
$output_subject = $forum->getSubject();

if (isset($output_subject)) {
	$forum->topic_id = $output_subject['topic_id'];
	
	unset($comment->user_id);
	$output_comments = $comment->getComments($output_subject['subject_id'], 1);
	
	$user->user_id = $output_subject['user_id'];
	$output_subject['author'] = $user->getProfile();
}

$output_subjects = $forum->getSubjects();


//ACS check
if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_hidden'])) { //resourece_id, Priv_id
	$forum->include_hidden = 1;
}

$output_topics = $forum->getTopics();


//setup bookmarks
$bookmark = new Bookmark($db, $c_node['cms']['item_type']['group_forum_subject'], $date, $user_id);
$bookmark->item_id = $subject_id;
//watching
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
//set or unset bookmarks
if (isset($_REQUEST['watch'])) {
	$bookmark->insertBookmark();
}
elseif (isset($_REQUEST['unwatch'])) {
	$bookmark->deleteBookmark();
}
//get and update bookmark
if ($bookmark->getBookmark()) {
	$bookmark->updateBookmark();
	$output_subject['bookmark']['watch'] = 1;
}

//recommended
$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
//set or unset bookmarks
if (isset($_REQUEST['recommend'])) {
	$bookmark->insertBookmark();
}
elseif (isset($_REQUEST['unrecommend'])) {
	$bookmark->deleteBookmark();
}
//get and update bookmark
if ($bookmark->getBookmark()) {
	$bookmark->updateBookmark();
	$output_subject['bookmark']['recommend'] = 1;
}


//get subject image
if (isset($output_subject['file_id'])) {
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	$file->file_id = $output_subject['file_id'];
	$output_subject['image'] = $file->getFileRecord();
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}


if (isset($output_subject['subject_title'])) {
	$template_pageLink = $lang['txt_subject'];
	$template_pageLinkNote = $output_subject['subject_title'];
}

include "inc/footer.inc.php";

?>
