<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Acs.class.php');
$acs = new Acs();
$acs->db = $db;
$section_id = $c_acs['arr_section']['user'];
$acs->section_id = $section_id;

//append language setup
require_once($languageArrayPath . 'arr_acs.lang.php');


//ROLES
//get role_id's from config and build the roles array
$config_roles = $c_acs['section_role'][$section_id];
if (!empty($config_roles)) {
	$output_roles = array();
	
	//loop through the array and get the name from the language file
	foreach($config_roles as $key => $i):
		$temp1['role_name'] = $lang['arr_acs']['role'][$i];
		$temp1['role_id'] = $i;
		array_push($output_roles, $temp1);
	endforeach;
}


//RESOURCES
//get resource_id's from config and build the resources array
$config_resources = $c_acs['section_resource'][$section_id];
if (!empty($config_resources)) {
	$output_resources = array();
	
	//loop through the array and get the name, desc from the language file
	foreach($config_resources as $key => $res):
		$temp1['resource_name'] = $lang['arr_acs']['resource'][$res];
		$temp1['resource_id'] = $res;
		$temp1['resource_desc'] = $lang['arr_acs']['resource_desc'][$res];
		
		//get privileges attached to each resource
		$config_privileges = $c_acs['resource_privilege'][$res];
		if (!empty($config_privileges)) {
			$temp1['privileges'] = array();
			
			//loop through the array and get the name from the language file
			foreach($config_privileges as $key1 => $priv):
				$temp2['privilege_name'] = $lang['arr_acs']['privilege'][$priv];
				$temp2['privilege_id'] = $priv;
				
				//for each privilege we now see if the permission is set against the role
				if (!empty($config_roles)) {
					$temp2['permissions'] = array();
					
					//loop through the array and check the permission
					foreach($config_roles as $key2 => $role):
						if ($acs->getPermission($role, $res, $priv)) {
						    $temp2['permissions'][] = 1;
						}
						else {
						    $temp2['permissions'][] = 0;
						}
					endforeach;
				}
				
				array_push($temp1['privileges'], $temp2);
			endforeach;
		}
		//push this resource info to the main array
		array_push($output_resources, $temp1);
	endforeach;
}


//move to template
if (isset($output_roles)) {
    $body->set('roles', $output_roles);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($output_resources)) {
    $body->set('resources', $output_resources);
}

include "inc/footer.inc.php";

?>
