<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
$section = "message";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Wiki/Wiki.php');
require_once($c_node['class_dir'] . 'User/Socialnetwork.class.php');


//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "user/" . $user_id . "/");
$wiki->disableRule('wikilink');//stop WIKI style links in the Blog



// Gettings list of friends
$network = new Socialnetwork($me['user_id'], $db, $me['node_id']);
$friends = $network->getSocialNetwork();


// Handling the message choices
if (isset($_REQUEST['send_message'])) {
	$message_subject = stripslashes(htmlspecialchars($data['message_subject']));
	$im->sendMessage($data['to_user_id'], $message_subject, $data['message_body']);
	header("Location: msg_list.php?" . SID);
	exit;
}
elseif (isset($_REQUEST['reply'])) {

	$message = new Message($db, $_REQUEST['message_id']); // create message
	$message->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);
	$output_message = $message->getMessage();             // get message

	// Getting username
	$to_user = $user->getUser($output_message['from_user_id']);
	$to_user_id = $output_message['from_user_id'];

	// Adding RE (langauge node?)
	$output_message["message_subject"] = "RE: ".$output_message["message_subject"];

	// Changing message_body
	$output_message["message_body"] = "\n\n----\n".$output_message["message_body"];

	// Checks if that user have blocked me....
	if ($im->checkUserBlocked($to_user_id)) {
		$display = "compose_allowed";
	}
}
elseif (isset($_POST['preview_message'])) {
	$output_message["message_subject"] = stripslashes(htmlspecialchars($data["message_subject"]));
	$output_message["message_body"] = stripslashes($data["message_body"]);
	$output_message['message_body_display'] = $wiki->transform($output_message['message_body'], 'Xhtml');
	$to_user_id = $data['to_user_id'];
	$to_user = $user->getUser($data['to_user_id']);

	$display = "preview_msg";

}
elseif (isset($_POST['edit_message_again'])) {
	$output_message["message_subject"] = stripslashes($data['message_subject']);
	$output_message["message_body"] = stripslashes($data["message_body"]);
	$to_user_id = $data['to_user_id'];
	$to_user = $user->getUser($data['to_user_id']);

	$display = "compose_allowed";

}
elseif (isset($_REQUEST['to_user_id'])) {

	//check to see whether we are allowed to IM this person
	if ($im->checkUserBlocked($_REQUEST['to_user_id'])) {
	    $to_user = $user->getUser($_REQUEST['to_user_id']);
		$to_user_id = $_REQUEST['to_user_id'];
		$output_message['message_subject'] = "";
		$output_message['message_body'] = "";

		$display = "compose_allowed";
	}

}
else {
	$output_message['message_subject'] = "";
	$output_message['message_body'] = "";
	$users = $network->getSocialNetwork();

	$display = "compose_allowed";
}


//----------------------------------------------------------------------------
// Setting statistics
$im->setStatistics();

// Getting statistics
$output_message_statistics = $im->getStatistics();
//----------------------------------------------------------------------------

//display "no compose" screen if MB is over 100% full
$percentage_used = floor((100/$output_message_statistics['total_size_allowed']) * $output_message_statistics['total_size']);
if (isset($percentage_used) && $percentage_used >= 100) {
    $display = "size_allocation_exceeded";
}


//move to template
if (isset($users)) {
	$body->set('users', $users);
}
if (isset($output_message)) {
	$body->set('message', $output_message);
}

if (isset($old_subject)) {
	$body->set('old_subject', $old_subject);
}
else {
	$body->set('old_subject', "");
}

if (isset($old_message)) {
	$body->set('old_message', $old_message);
}
else {
	$body->set('old_message', "");
}

$body->set('friends', $friends);// List of friends

if (isset($to_user_id)) {
    $body->set('to_user_id', $to_user_id);// to_user_id
}

if (isset($to_user)) {
    $body->set('to_user', $to_user);// Name of user to_user_id
}

if (isset($display)) {
    $body->set('display', $display);// Name of user to_user_id
}

$body->set('message_statistics', $output_message_statistics);			// Stats...
$body->set('message_status_read', $c_node['message_status_read']);		// Status code: READ
$body->set('message_status_unread', $c_node['message_status_unread']);	// Status code: UNREAD


$template_pageLink = "message";
include "inc/footer.inc.php";

?>
