<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//append language setup
require_once($languageArrayPath . 'arr_level.php');



if (isset($_REQUEST['section_id'])) {
	$section_id = $_REQUEST['section_id'];
}

if (isset($_REQUEST['topic_id'])) {
	$topic_id = $_REQUEST['topic_id'];
}

//post
if (isset($data['section_id'])) {
	$section_id = $data['section_id'];
}


//setup forum
$forum = new Forum($group_id);
$forum->date = $date;
$forum->db = $db;
$forum->user_id = $me['user_id'];
$forum->group_id = $group_id;


//process requests
if (isset($_POST['add_topic'])) {
	if (empty($data['topic_sticky'])) {
		$data['topic_sticky'] = "NULL";
	}

	if (empty($data['level_id'])) {
		$data['level_id'] = $c_node['group_type']['section'];
	}

	if (empty($data['topic_locked'])) {
		$data['topic_locked'] = "NULL";
	}

	$insert = $forum->insertTopic($data['section_id'], $data['topic_title'], $data['topic_body'], $data['topic_image_id'], $data['topic_sticky'], $data['topic_locked'], $data['level_id']);

	if ($insert[0][0] == "success") {
		//update stats
		$user->user_id = $me['user_id'];
		$user->setStatistic($c_node['user_statistic_type_id']['total_forum_topics']);

		//set group stats
		$group->setStatistic($c_node['group_statistic_type_id']['total_forum_topics'], $forum->groupTopicCount());

		//update the reply stats
		// this is done on each reply by adding 1 to the stat, however here (more occasionally than at adding a reply)
		//we reset the stat and recount all replies....just a double check // tom 6th May 2004
		$group->setStatistic($c_node['group_statistic_type_id']['total_forum_replies'], $forum->groupReplyCount());

		//set group member stats
		$group->setGroupMemberStatistic($c_node['group_member_statistic_type_id']['total_topics'], $me['user_id']);

		//goto section list
		return header("Location: g_forum.php?group_id=". $group_id . "&amp;" . SID);
		exit;

	    //$success = $insert;
	}
	else {
	    $error = $insert;
	}

}
elseif (isset($_POST['edit_topic'])) {
	$topic_id = $data['topic_id'];

	if (isset($data['topic_sticky'])) {
	    $topic_sticky = 1;
	}
	else {
	    $topic_sticky = "NULL";
	}

	if (isset($data['topic_locked'])) {
	    $topic_locked = 1;
	}
	else {
	    $topic_locked = "NULL";
	}

	if (isset($data['topic_image_id'])) {
	    $topic_image_id = $data['topic_image_id'];
	}

	$update = $forum->updateTopic($data['topic_id'],$data['section_id'], $data['topic_title'], $data['topic_body'], $topic_sticky, $topic_locked, $topic_image_id, $data['level_id']);

	if ($update[0][0] == "success") {
	    //$success = $update;
		//goto section list
		return header("Location: g_forum_topic.php?group_id=". $group_id . "&amp;topic_id=" . $data['topic_id'] . "&amp;" . SID);
		exit;
	}
	else {
	    $error = $update;
	}

}
elseif (isset($_POST['delete_topic'])) {
	$delete = $forum->deleteTopic($data['topic_id']);

	if ($delete[0][0] == "success") {

		//set group stats
		$group->setStatistic($c_node['group_statistic_type_id']['total_forum_topics'], $forum->groupTopicCount());


	    $success = $delete;
	}
	else {
	    $error = $delete;
	}
}


if (isset($section_id) && isset($topic_id)) {
	$forum->topic_id = $topic_id;
	$forum->bookmark_watching_id = $c_node['bookmark_type_watching'];
	$forum->image = $image;

	$display = "edit_topic";
	$output_topic = $forum->topicDetails($topic_id);

	//work out whether we can show delete button
	$output_subject_count = $forum->subjectCount ();
}
else {
	$display = "add_topic";
}


$output_images = $image->getImages('group', $group_id, 't2');

$output_sections = $forum->sectionList();


//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_sections)) {
	$body->set('sections', $output_sections);
}

if (isset($output_topic)) {
	$body->set('topic', $output_topic);
}
if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_images)) {
	$body->set('images', $output_images);
}

if (isset($output_subject_count)) {
	$body->set('subject_count', $output_subject_count);
}

$body->set('section_id', $section_id);
$body->set('user_levels', $c_node['user_level_id']);

include "inc/footer.inc.php";

?>
