<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";


//append language setup
require_once($languageTextPath . 'node_rules.lang.php');
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');

if (isset($_POST['user_pending'])) {
	$output_apply = setMembership($group_id, $c_node['user_level_id']['pending']);

	//set stats
	if (isset($output_apply)) {
    	$group->setStatistic($c_node['group_statistic_type_id']['total_members']);
	}

	$display = "pending";
}
elseif (isset($_POST['user_member'])) {
	$output_apply = setMembership($group_id, $c_node['user_level_id']['member']);
	$display = "member";
}


//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($c_node['group_type'])) {
	$body->set('group_types', $c_node['group_type']);
}

if (isset($c_node['user_level_id'])) {
	$body->set('user_level_ids', $c_node['user_level_id']);
}

include "inc/footer.inc.php";



/*
* setMembership
* Tom Calthrop 7th April 2004
*/
function setMembership ($group_id,  $level_id) {

	global $db, $me;


	$datetime = date("Y-m-d H:i:s");
	$datetime = $db->DBDate($datetime);


	//find out if we have a record already
	$query = "
		SELECT user_id, level_id
		FROM " . $db->prefix . "_group_member
		WHERE
		group_id=" . $group_id . " and
		user_id=" . $me['user_id']
	;

	$result = $db->Execute($query);

	if (!isset($result)) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	elseif (isset($result->fields['level_id'])) {
		$result->Close();

		$query = "
			UPDATE " . $db->prefix . "_group_member SET level_id=" . $level_id . " WHERE
			group_id=" . $group_id . " and
			user_id=" . $me['user_id']
		;
		//echo $query;
		$result = $db->Execute($query);
		$result->Close();

		return true;
	}
	else {
		$result->Close();

		$query = "
			INSERT INTO " . $db->prefix . "_group_member (
			group_id, level_id, member_create_datetime, user_id , node_id
			) VALUES (
			" . $group_id . ",
			" . $level_id . ",
			" . $datetime . ",
			" . $me['user_id'] . ",
			" . $me['node_id'] . "
			)"
		;
		//echo $query;
		$result = $db->Execute($query);

		$result->Close();

		return true;
	}
}
?>
